/*  Pneumoscope Version 1.0
    Main.h
    Florian CHAYS
 */

// ==== PROTOTYPES ====
void clear_memory();
void read_range(int max_data);

void init();
void flip_led();
void bluetooth();
void test_flash_1();
void test_flash_2();
void test_flash_3();
void test_ADC();

bool error_check(int index, unsigned char data_in, unsigned char data_out);


// ==== GLOBAL VARIABLES ====
bool nr_error[3];
int MAX_DATA;
int start_add;

enum States
{
    ST_INIT,
    ST_P1,
    ST_P2,
    ST_P3,
    ST_P4,
    ST_END
};
States MS_State;

// ==== INPUT / OUTPUT ====
// Interrupt
InterruptIn button(P0_12);

// Digital Outputs
DigitalOut myled(P0_13);

// Analogs Inputs
AnalogIn Mic_Amb(P0_2);
AnalogIn Mic_Pat(P0_3);
AnalogIn Temp_1(P0_4);
AnalogIn Temp_2(P0_5);

// SPI_MX25R(PinName mosi, PinName miso, PinName sclk, PinName cs) ;
SPI_MX25R spi_mem(QSPI_FLASH1_IO0, QSPI_FLASH1_IO1, QSPI_FLASH1_SCK, QSPI_FLASH1_CSN);
DigitalIn Flash_nReset(QSPI_FLASH1_IO3);
DigitalIn Flash_WP(QSPI_FLASH1_IO2);