/*  Pneumoscope Version 1.0
    Florian CHAYS
 */

#include <cctype>
#include <events/mbed_events.h>
#include "mbed.h"
#include "ble/BLE.h"
#include "SPI_MX25R.h"
#include <main.h>

/*  ==========================
    =          MAIN          =
    ==========================*/
int main()
{
    MS_State = ST_INIT;
    int go_out = 1;
    
    while(go_out){
        switch(MS_State){
            case ST_INIT :
                init();
                break;
            
            case ST_P1 :
                test_flash_1();
                MS_State = ST_P2;
                break;
                
            case ST_P2 :
                test_flash_2();
                MS_State = ST_P3;
                break;
            
            case ST_P3 :
                test_flash_3();
                MS_State = ST_P4;
                break;
                
            case ST_P4 :
                test_ADC();
                MS_State = ST_END;
                break;             
                
            case ST_END :
                printf("\n\r==== TESTS RESULTS ====\n\n\r");
                printf("Test done with %d data\n\r",MAX_DATA);
                printf("1. Flash 1-by-1             : %d\n\r",nr_error[0]);
                printf("2. Flash array              : %d\n\r",nr_error[1]);
                printf("3. Flash multiples arrays   : %d\n\r",nr_error[1]);
                printf("\nRestart test session (0/1)?\n\r") ;
                printf("> ") ;
                scanf("%d", &go_out) ;
                printf("Choice %d",go_out);
                if (go_out) MS_State = ST_INIT;
                break;
        }
    }
    printf("\n\r==== SESSION ENDED ====\n\n\r");
}

/*  ===========================
    =        FUNCTIONS        =
    ===========================*/

// ==== INITIALIZATION ====
void init(){
    printf("\n\r==== Pneumoscope TestBench ====\n\n\r");
    printf("Enter size of array\n\r") ;
    printf("> ") ;
    scanf("%d", &MAX_DATA) ;
    
    start_add = 0;
    
    // Resistance to size of 0
    MAX_DATA = (MAX_DATA == 0) ? 16 : MAX_DATA;
    printf("\n\rTest with %d bytes\n\r",MAX_DATA);
    
    for (int i = 0; i < 3; i++){
        nr_error[i] = 0;
    }
    
    button.rise(&flip_led); // Button Interrupt
    
    // Next State
    MS_State = ST_P1;
}

// ==== TEST FLASH 1 ====
void test_flash_1(){
    printf("\n\r==== 1. Flash Memory Test 1-by-1 ====\n\n\r");
    clear_memory();
    
    uint8_t data_in, data_out;

    for (int address = start_add; address < MAX_DATA; address++){
        // Generating data to be written
        data_in = rand() % 256;
        data_out = 0;

        // Send data
        spi_mem.writeEnable();
        spi_mem.programPage(address, &data_in, 1);
        while(spi_mem.readStatus() & 0x01){}
        
        // Read data written
        data_out = spi_mem.read8(address);
        nr_error[0] += error_check(address, data_in, data_out);
        //if (nr_error[0]) break;
    }

    read_range(MAX_DATA);
    if (!nr_error[0]){
        printf("Test passed successfully\n\r");
    }
}

// ==== TEST FLASH 2 ====
void test_flash_2(){
    printf("\n\n\r==== 2. Flash Memory Test Array ====\n\n\r");
    clear_memory();
    
    uint8_t data_in[MAX_DATA], data_out[MAX_DATA];
    int address;
    
    // Generating data to be written
    for (address = start_add; address < MAX_DATA; address++){
        data_in[address] = rand() % 256;
        data_out[address] = 0;
    }
    
    // Send data
    spi_mem.writeEnable();
    spi_mem.programPage(start_add, data_in, MAX_DATA);
    while(spi_mem.readStatus() & 0x01){} // Check status
    printf("[INFO] Data sent\n\r");
    
    // Read data written
    printf("Checking In/Out Data ");
    for (address = start_add; address < MAX_DATA; address++){
        printf(".");
        data_out[address] = spi_mem.read8(address);
        nr_error[1] += error_check(address, data_in[address], data_out[address]);
        //if (nr_error[1]) break;
    }
    printf("\n\r");
    
    read_range(MAX_DATA);
    if (!nr_error[1]){
        printf("Test passed successfully\n\r");
    }
}

// ==== TEST FLASH 3 ====
void test_flash_3(){
    printf("\n\n\r==== 3. Flash Memory Test Multiple Arrays ====\n\n\r");
    clear_memory();
    
    uint8_t data_size = 4;
    uint8_t data_in[256*data_size], data_out[256*data_size];
    uint8_t buffer[256];
    int address;
          
    // Generating data to be written
    for (int iter = 0; iter < 256*data_size; iter++){
        data_in[iter] = rand() % 256;
        data_out[iter] = 0;
    }
    for (int iter = 0; iter < 256; iter++){
        buffer[iter] = 0;
    }
        
    for (int nbr = 0; nbr < data_size; nbr++){
        // Send data
        for (int idx = 0; idx < 256; idx++){
            buffer[idx] = data_in[nbr*256+idx];
        }
        spi_mem.writeEnable();
        spi_mem.programPage(nbr*256, buffer, 256);
        while(spi_mem.readStatus() & 0x01){} // Check status
    }
    printf("[INFO] Data sent\n\r");
        
    // Read data written
    printf("Checking In/Out Data ");
    for (address = 0; address < data_size*256; address++){
        printf(".");
        data_out[address] = spi_mem.read8(address);
        nr_error[2] += error_check(address, data_in[address], data_out[address]);
        //if (nr_error[1]) break;
    }
    printf("\n\r");
    
    read_range(data_size*256);
    if (!nr_error[2]){
        printf("Test passed successfully\n\r");
    }
}

// ==== TEST ADC ====
void test_ADC(){
    printf("\n\n\r==== 4. ADC Test ====\n\n\r");
    clear_memory();
    
    // ADC 12 bits framerate 200 ksps during 10 sec : 4 Mo
    
    uint8_t data_in[2], data_out[2];
    float analog_in, analog_out;
    int max_adc = 32;
    
    // Generating data to be written
    for (int i = 0; i < max_adc; i++){
        analog_in = Mic_Pat.read();
        printf("%d : float = %f / hex = %x\n\r",i, analog_in, *(unsigned int*)&analog_in);
        data_in[0] = ((*(unsigned int*)&analog_in) >> 8) & 0xFF;
        data_in[1] = (*(unsigned int*)&analog_in) & 0xFF;
        
        // Send data
        spi_mem.writeEnable();
        spi_mem.programPage(2*i, data_in, 2);
        while(spi_mem.readStatus() & 0x01){} // Check status
        wait_us(5);
    }
    read_range(max_adc*2);
}

// =========================
// ==== OTHER FUNCTIONS ====
void flip_led(){
    myled = !myled;
}

void read_range(int max_data){
    printf("[INFO] Memory State :");
    uint8_t data[max_data] ;
    int current_address = 0;
    for (int i = 0 ; current_address <  max_data; i++ ) {
        printf("\n\r%d : ", current_address ) ;
        for (int j = 0 ; j < 8 ; j++ ) {
            data[j] = spi_mem.read8(current_address ) ;
            printf("%02X ", data[j]) ;
            current_address++;
        }
    }
    printf("\n\n\r");
}

void clear_memory(){
    spi_mem.writeEnable();
    spi_mem.sectorErase(0);
    while(spi_mem.readStatus() & 0x01){} // Check status
    printf("[INFO] Memory Cleared\n\r");
}

bool error_check(int index, unsigned char data_in, unsigned char data_out){
    if (data_in != data_out){
        printf("[ERROR] Address %d : In = %d / Out = %d\n\r",index ,data_in,data_out);
        return 1;
    }else{
        return 0;
    }
}