/**
 * PS/2 mouse interface control class (Version 0.0.1)
 *
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 */

#ifndef _PS2MS_H_
#define _PS2MS_H_

#include "mbed.h"

/**
 * PS/2 mouse interface control class.
 */
class PS2MS {
public:
    /**
     * Create.
     *
     * @param clk_pin Clock pin.
     * @param dat_pin Data pin.
     */
    PS2MS(PinName clk_pin, PinName dat_pin);

    /**
     * Destory.
     */
    virtual ~PS2MS();

    /**
     * Get a data from a PS/2 device.
     *
     * @return A data from a PS/2 device.
     */
    virtual int getc(void);

    /**
     * Set timeout.
     *
     * @param ms Timeout ms.
     */
    virtual void setTimeout(int ms);
    void init_work(void);
    void detatch(void);
    int sendCommand(char c);
private:
    static const int RINGBUFSIZ = 2048;
    static const int MAX_RETRY = 1000000;
    static const int CLOCK_DOWN_EDGE_WAIT_MS = 1000000;
    volatile bool mSending;
    volatile bool mInFuncFall;
    
    InterruptIn clk;    /**< Interrupt input for CLK. */
    DigitalInOut clkOut;   /**< Digital input/output for CLK. */
    DigitalInOut dat;      /**< Digital input/output for DAT. */
    Timeout wdt;    /**< Watch dog timer. */
    Timer tot;      /**< Timeout timer. */
    int timeout;    /**< Timeout[ms] for getc(). */

    typedef struct {
        int bitcnt;
        int cStart;
        int cEnd;
        uint8_t buffer[RINGBUFSIZ];
    } work_t;
    work_t work;

    void func_timeout(void);
    void func_fall(void);
    bool waitClockDownEdge(void);
    bool waitClockUpLevel(void);

};

#endif
