#include "ping.h"

Ping::Ping(PinName signalPin) : mSignalIo(signalPin), mEvent(signalPin), 
        mBusy(0), mValid(0), mContinuous(0),
        mDelayBetweenReadings(DEFAULT_MEASUREMENT_DELAY_US), mTimer(), mRawReading(0) {
    mEvent.rise(this, &Ping::start);
    mEvent.fall(this, &Ping::stop);
}

bool Ping::startReading() {
    return this->startReading(false);
}

bool Ping::startReading(bool continuous) {
    mContinuous = continuous;
    if (mBusy) return false;
    
    mSignalIo.output();
    mSignalIo.write(0);
    wait_us(3);
    mSignalIo.write(1);
    wait_us(3);
    mSignalIo.write(0);
    mSignalIo.input();
    
    return true;
}

void Ping::start() {
    mBusy = true;
    mValid = false;
    mTimer.reset();
    mTimer.start();
}

void Ping::stop() {
    mBusy = false;
    mValid = true;
    // The time it takes is for a round trip.  We divide by two to get the time for one way.
    mRawReading = mTimer.read_us() >> 1;
    mTimer.stop();
    mCallback.call(mRawReading);
    if (mContinuous) mMeasureDelayTicker.attach_us(this, &Ping::nextMeasurement, mDelayBetweenReadings);
}

void Ping::nextMeasurement() {
    mMeasureDelayTicker.detach();
    this->startReading(mContinuous);
}