#ifndef _HUBSAN_X4_TX
#define _HUBSAN_X4_TX

#include "A7105.h"

enum{
    FLAG_VIDEO= 0x01,   // record video
    FLAG_FLIP = 0x08,   // enable flips
    FLAG_LED  = 0x04    // enable LEDs
};

static const uint8_t kAllowedChannels[] =
        {0x14, 0x1E, 0x28, 0x32, 0x3C, 0x46, 0x50, 0x5A, 0x64, 0x6E, 0x78, 0x82};
static const uint32_t kTxId = 0xDB042679;

/**
 * Class for communicating with a Hubsan X4 using the A7105TxRx library
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "HubsanTx.h"
 *
 * #define A7105_SPI_FREQUENCY  10000000 // 10MHz
 * 
 * HubsanTx hubsan(D4, D5, D3, D6, A7105_SPI_FREQUENCY);
 * 
 * int main() {
 *     // init
 *     hubsan.init();
 * }
 * @endcode
 */
class HubsanTx : public A7105 {
    public:
        /**
         * @param mosi Pin used to transmit data to the slave
         * @param miso Pin used to receive data from the slave
         * @param clk Pin used for the clock
         * @param cs Pin used for the chip select
         * @param freqHz Frequency used to clock data in and out
         */
        HubsanTx(PinName mosi, PinName miso, PinName clk, PinName cs, uint32_t freqHz);
        
        /**
         * Initialize the A7105 to communicate with a Hubsan X4
         */
        int8_t init();
    
    private:
        uint8_t _packet[16];
        uint8_t _channel;
        uint32_t _sessionId;
        uint8_t _state;
        uint8_t _packetCount;
};

#endif // _HUBSAN_X4_TX