#include "mbed.h"
#include "HubsanTx.h"

HubsanTx::HubsanTx(PinName mosi, PinName miso, PinName clk, PinName cs, uint32_t freqHz)
    : A7105(mosi, miso, clk, cs, freqHz) {
}

int8_t HubsanTx::init() {
    uint8_t if_calibration1;
    uint8_t vco_calibration0;
    uint8_t vco_calibration1;

    reset();
    setId(0x55201041);
    writeRegister(A7105_0B_GPIO1_PIN_I, 0x19);
    writeRegister(A7105_01_MODE_CONTROL, 0x63);
    writeRegister(A7105_03_FIFOI, 0x0f);
    writeRegister(A7105_0D_CLOCK, 0x05);
    writeRegister(A7105_0E_DATA_RATE, 0x04);
    writeRegister(A7105_15_TX_II, 0x2b);
    writeRegister(A7105_18_RX, 0x62);
    writeRegister(A7105_19_RX_GAIN_I, 0x80);
    writeRegister(A7105_1C_RX_GAIN_IV, 0x0A);
    writeRegister(A7105_1F_CODE_I, 0x07);
    writeRegister(A7105_20_CODE_II, 0x17);
    writeRegister(A7105_29_RX_DEM_TEST_I, 0x47);

    strobe(A7105_STANDBY);
    
    return 1;
}