#include "mbed.h"
#include "mStepper.h"


typedef enum {go = 0,back = 1,left = 2,right = 3, both = 4} Direction; //global enumerator
typedef enum {CW = 0, CCW = 1} Clock;

class Robot{
private:
    float vel; // velocity per max
    mStepper LM, RM; // left motor, right motor
    DigitalOut l_enb, r_enb; // left enable pin, right enable pin
    
public:
    Robot(PinName l_dir, PinName l_step, PinName _l_enb, PinName r_dir, PinName r_step, PinName _r_enb);
    
    void enable(uint8_t _dir); // enable certain motor
    void disable(uint8_t _dir); // diable certain motor
    
    uint8_t isRun(); // if motor's distance to go is left return true or not return 0
    
    void run(uint8_t _dir); // drive motor
    void run_speed(uint8_t _dir);
    void stop(uint8_t _dir); // stop motor, direction is left or right or both
    
    void move_cm(uint8_t _dir, float _distance_cm); // move constant distance
    void move_speed(uint8_t _dir, float _vel); // move max speed * percent
    
    void turn_deg(uint8_t _dir, float _ang); // robot turn left or right
    void turn_LM(uint8_t _dir, float _ang, float _vel); // turn only left motor, default percent of velocity is 100%
    void turn_RM(uint8_t _dir, float _ang, float _vel); // turn only right motor, default percent of velocity is 100%
};

