#include "mbed.h"
#include <I2CSlave.h>
#include "Robot.h"

#define L_dir D2
#define L_step D3
#define L_enb D4
#define R_dir D5
#define R_step D6
#define R_enb D7

#define CMD_NULL 0
#define CMD_LM_MOVE 1
#define CMD_RM_MOVE 2
#define CMD_MOTOR_STOP 3
#define CMD_ROBOT_MOVE 4
#define CMD_ROBOT_STOP 5

#define device_addr 0x0A<<1
#define BUFF_SIZE 52


char data[BUFF_SIZE] = {0x0A, 1, CMD_NULL, (CMD_NULL&0xFF), 0, 0, 0, 0, 0, 0, 0, 0,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 20,
                        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
char sub_addr;
I2CSlave slave(I2C_SDA, I2C_SCL);
AnalogIn adc_temp(ADC_TEMP);

Robot a(L_dir, L_step, L_enb, R_dir, R_step, R_enb);

//void writeByte(uint8_t address, uint8_t regAddress, uint8_t data);
//char readByte(uint8_t address, uint8_t regAddress);

/* protocol
 *    [0]         [1]     [2]  [3]   [4]  [5] [6] [7] [8] [9] [10] [11] [12] [13] [14] [15] [16] [17] [18] [19] [20] [21] [22] [23] [24] [25] [26] [27] [28] [29] [30] [31] [32] [33] [34] [35] [36] [37] [38] [39] [40] [41] [42] [43] [44] [45] [46] [47] [48] [49]
 *           device_addr        LEN  CMD  write_data
 */
int main()
{
    PC_DEBUG("hello")
    slave.frequency(400000);
    printf("slave started\n");
    slave.address(device_addr);
    int status = 0;
    while(1){
        status = slave.receive();
        if(status == I2CSlave::WriteAddressed){
            sub_addr = slave.read();
            int len = slave.read(data+sub_addr, BUFF_SIZE);
            printf("Read from master: %02x, %02x: ", sub_addr, len);
            for(int i = 0; i < BUFF_SIZE; i++){
                printf("%02X ", data[i]);
            }
            printf("\n");
        }
        else if(status == I2CSlave::ReadAddressed){
            
            slave.write(data+sub_addr, data[1]);
            data[1] = 1;
            printf("Written to master: ");
            for(int i = 0; i < 52; i++){
                printf("%02X ", data[i]);
            }
            printf("\n");
        }
    }
}

/*void writeByte(uint8_t address, uint8_t regAddress, uint8_t data){
    char data_write[2];
    data_write[0] = regAddress;
    data_write[1] = data;
    i2c.write(address, data_write, 2, 0);
}

char readByte(uint8_t address, uint8_t regAddress){
    char data[1];// 'data' will store the register data
    char data_write[1]; // for assigning register address
    data_write[0] = regAddress;
    i2c.write(address, data_write, 1, 1);// no stop
    i2c.read(address, data, 1, 0);
    return data[0];
}*/