#include "mbed.h"

const uint8_t BUFF_SIZE = 20;

enum {STX=0x02, ETX=0x02, AKN=0x06, NAK=0x16} PROTOCOL;
enum {CMD_AVAILABLE, CMD_PRINT, CMD_COMPLETE} PRINT_CMD;

// 나중에 flag를 전부 class flag로 선언해서 묶고, extern하기 쉽게 만들자.
// 프린터 위치 초기화, 액추에이터 작동, 다음줄 출력시 프린터 위치 아직 설정 안됨

volatile bool TXflag = false;
volatile bool CheckFlag;

volatile uint8_t buffer[BUFF_SIZE];
volatile uint8_t data[10];
volatile uint8_t CMD;
volatile uint8_t receivedCS;
volatile uint8_t LEN;

void flush();

uint16_t CheckSum(volatile uint8_t* data, int8_t pos, int8_t len);
void Set_Data(volatile uint8_t* target, volatile uint8_t* data, int8_t pos, int8_t len);
void Set_Data(volatile uint8_t target, volatile uint8_t* data, int8_t pos);
void print_Data(volatile uint8_t* data, uint8_t len);

extern class Serial pc;
extern 

//수신 인터럽트 (
void RX_ISR(){
    while(pc.readable()){
        int i = 0;
        while(pc.readable()) buffer[++i] = pc.getc();
        if (*buffer == STX){
            Set_Data(CMD, buffer , 1);
            Set_Data(LEN, buffer, 2);
            if (*(buffer+LEN) != ETX){
                pc.putc(NAK); // NAK echo
                flush();
                return;
            }
            Set_Data(data, buffer, 3, LEN);
            Set_Data(receivedCS, buffer, 3 + LEN);
            uint16_t CS = CheckSum(data, 0, LEN);
            if (CS != receivedCS){
                pc.putc(NAK); // NAK echo
                flush();
                return;
            }
            print_Data(buffer, 5 + LEN);
            pc.putc(AKN);
            
        }
        else{
            while(i < BUFF_SIZE){
                *(buffer + i++) = 0;
            }
        }
    }
}

// 배열 지우기
void flush(){
    int i = 0;
    while(i++<BUFF_SIZE) *(buffer + i) = 0;
}

uint16_t CheckSum(volatile uint8_t* data, int8_t pos, int8_t len){
    int cs = 0;
    for(int i = 0; i < len; i++)
        cs += *(data + i + pos);
    return (~cs+1) & 0xFF;
}

// Set Data
void Set_Data(volatile uint8_t* target, volatile uint8_t* data, int8_t pos, int8_t len){
    for(int i = 0; i < len; i++)
        *(target + i) = *(data + i + pos);
}

// Set a datum (overroading) 
void Set_Data(volatile uint8_t target, volatile uint8_t* data, int8_t pos){
        target = *(data + pos);
}

// print transmit data at Serial Monitor of PC
// for debugging
void print_Data(volatile uint8_t* data, uint8_t len){
    pc.printf("  received data: ");
    for(int i = 0; i < len; i++)
        pc.printf("%#X ", *(data + i));
    pc.printf("\n");
}