#include "mbed.h"

#include "cyassl/ctaocrypt/hmac.h"
#include "cyassl/ctaocrypt/aes.h"

#include "MbedJSONValue.h"
#include "LinearTempSensor.h"

int main() {
    
    pc.baud(115200);

    MbedJSONValue sensorResults;

    Aes enc;
    Aes dec;
    
    Hmac    hmac;
    
    bytekey[24];    // fill key with keying material
    bytebuferr[2048];   // fill buffer with data to digest
    bytehmacDigest[SHA256_DIGEST_SIZE];
    
    HmacSetKey(&hmac, SHA256, key, sizeof(key));
    HmacUpdate(&hmac, buffer, sizeof(buffer));
    HmacFinal(&hmac, hmacDigest);

    const byte key[16] = {  'm', 'n', 'b', 'v', 'c', 'x', 'z', 'l', 'k', 'j', 'h', 'g', 'f', 'd', 's', 'a' };
    const byte iv[16] = { 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'p', 'o', 'i', 'u', 'y', 't', 'r' };

    byte plain[128];   // an increment of 16, fill with data
    byte cipher[32];
    
    std::string s;
    
    Vout = sensor.Sense();          // Sample data (read sensor)
    Tav  = sensor.GetAverageTemp(); // Calculate average temperature from N samples
    To   = sensor.GetLatestTemp();  // Calculate temperature from the latest sample
    
    TempValue = sensor.GetAverageTemp();
    
    //Create JSON
    sensorResults["DATA1"][0] = "Result";
    sensorResults["DATA1"][1] = 5.5;
    sensorResults["DATA2"][0] = "Result";
    sensorResults["DATA2"][1] = 700;
    sensorResults["DATA3"][0] = "Result";
    sensorResults["DATA3"][1] = TempValue;

    //Serialize JSON
    s = sensorResults.serialize();
    //sl = s.size();

    //Print JSON string
    pc.printf("json: %s\r\n", s.c_str());
    
    //Convert JSON string to a char array to encrypt
    //char *a=new char[s.size()+1];
    plain[s.size()]=0;
    memcpy(plain,s.c_str(),s.size());//<-- Fills plain array with the JSON values
    
    // encrypt
    AesSetKey(&enc, key, sizeof(key), iv, AES_ENCRYPTION);
    AesCbcEncrypt(&enc, cipher, plain, sizeof(plain));
    
    //cipher now contains the cipher text from the plain text.
    
    // decrypt
    AesSetKey(&dec, key, sizeof(key), iv, AES_DECRYPTION);
    AesCbcDecrypt(&dec, plain, cipher, sizeof(cipher));
}
