#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"
#include "DebounceIn.h"

#define WS2812_BUF 8  //number of LEDS in the array
#define NUM_COLORS 5  //number of colors in the array

//debouces buttons and attaches Pull Up resistors to each input
DebounceIn button1(PB_4, PullUp);
DebounceIn button2(PA_9, PullUp);
DebounceIn button3(PB_6, PullUp);
DebounceIn button4(PB_8, PullUp);
PixelArray px(WS2812_BUF); //sets number of LEDs
// See the program page for information on the timing numbers
// Timing numbers for the NUCLEO-F411RE:  7, 15, 10, 15
// Timing numbers for the NUCLEO-L476RG:  3, 12,  9, 12
WS2812 ws(PB_3, WS2812_BUF,  3, 12, 9, 12);
int state1 = 0;
int state2 = 0;
int state3 = 0;
int state4 = 0;
int state = 0;

void button1fall() { //button1 is pushed
    if(state2 == 0 & state3 == 0 & state4 == 0) { //if no other buttons are on
        state1 = !state1; //change the state of button1
    }
}
void button2fall() { //button2 is pushed
    if(state1 == 0 & state3 == 0 & state4 == 0) { //if no other buttons are on
        state2 = !state2; //change the state of button2
    }
}
void button3fall() { //button3 is pushed
    if(state2 == 0 & state1 == 0 & state4 == 0) { //if no other buttons are on
        state3 = !state3; //change the state of button3
    }
}
void button4fall() { //button4 is pushed
    if(state2 == 0 & state3 == 0 & state1 == 0) { //if no other buttons are on
        state4 = !state4; //change the state of button4
    }
}
int main()
{
    button1.fall(callback(button1fall), 80000);
    button2.fall(callback(button2fall), 80000);
    button3.fall(callback(button3fall), 80000);
    button4.fall(callback(button4fall), 80000);
    
    ws.useII(WS2812::PER_PIXEL); // use per-pixel intensity scaling
    
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0x000000,0x00FFFF,0xFFFF00,0xFFFFFF,0xFF0000};
    
    while (1) 
    {
        // According to which button is pushed, a color will display until the same button is pushed again
        if(button1 == 0 & state2 == 0 & state3 == 0 & state4 == 0) {
            if(state1 == 1) {
                state = 1;
            }
            else {
                state = 0;
            }
        }
        else if(button2 == 0 & state1 == 0 & state3 == 0 & state4 == 0) {
            if(state2 == 1) {
                state = 2;
            }
            else {
                state = 0;
            }
        }
        else if(button3 == 0 & state1 == 0 & state2 == 0 & state4 == 0) {
            if(state3 == 1) {
                state = 3;
            }
            else {
                state = 0;
            }
        }
        else if(button4 == 0 & state1 == 0 & state2 == 0 & state3 == 0) {
            if(state4 == 1) {
                state = 4;
            }
            else {
                state = 0;
            }
        }
        //write the color value for each pixel
        px.SetAll(colorbuf[state]);  
        //write the birghtness intensity value for each pixel
        px.SetAllI(20);
        //writes the colors to the neopixels
        for (int i = WS2812_BUF; i >= 0; i--) {
            ws.write(px.getBuf());
        }
    }
}