#ifdef TARGET_M480
#include "BurstSPI.h"

void BurstSPI::fastWrite(int data) {
    //Wait until FIFO has space
//    SPI_T *spi_base = (SPI_T *) NU_MODBASE(_peripheral->spi.spi.spi);
#if 1
    write(data);
#else
    spi_master_write(&(_peripheral->spi), data);
#endif
    }

void BurstSPI::clearRX( void ) {
    //We put in a delay here, this function shouldn't be called very often, so not a huge problem
    //Without delay you will rise the CS line before it is finished (been there, done that)
    //We use time required to transmit 20 bits (8 bits being transmitted, 8 bits in FIFO, 4 bits safety margin
    
    float bytetime = 20.0/_hz;
    wait(bytetime);    
    //Wait until status is flagged that we can read, read:
//    SPI_T *spi_base = (SPI_T *) NU_MODBASE(_peripheral->spi.spi.spi);
}
#endif
