#ifndef MBED_SOPHIA_H
#define MBED_SOPHIA_H
 
#include "mbed.h"
#define FWD 1
#define REV 0
#define LEFT 0
#define RIGHT 1

/** Interface to control a Sophia robot 
 *
 */
class Sophia {
public:
    /** Set the direction of Sophia and the speed of the motor
     * 
     * @param speed The speed of the motor as a normalised value between -1.0 and 1.0
     * @param direction The desired direction to move the robot, FWD or REV
     */
    void move(float speed, int direction);

    /** Sets the side to turn and the speed of the motor
     * 
     * @param speed The speed of the motor as a normalised value between -1.0 and 1.0
     * @param direction The desired direction to move the robot, LEFT or RIGHT.
     */
    void turn(float speed, int direction);

    /** Sets the side to spin and the speed of the motor
     * 
     * @param speed The speed of the motor as a normalised value between -1.0 and 1.0
     * @param direction The desired direction to move the robot, LEFT or RIGHT.
     */
    void spin(float speed, int direction);
};
 
#endif