#include "mbed.h"
#include "Motor.h"
#include "Sophia.h"

Motor motor_right(PTD4, PTC13, PTC12);    // pwm, fwd, rev
Motor motor_left(PTD4, PTA13, PTD5);

void Sophia::move(float speed, int direction) {
    if(direction) {
        motor_right.speed(speed);
        motor_left.speed(speed);
    }
    else {
        motor_right.speed(-speed);
        motor_left.speed(-speed);    
    }
}

void Sophia::turn(float speed, int direction) {
    if(direction) {
        motor_right.speed(0.0);
        motor_left.speed(speed);
    }
    else {
        motor_right.speed(speed);
        motor_left.speed(0.0);
    }
}
void Sophia::spin(float speed, int direction) {
    if(direction) {
        motor_right.speed(-speed);
        motor_left.speed(speed);
    }
    else {
        motor_right.speed(speed);
        motor_left.speed(-speed);
    }
}