#define POST_URL             "https://{subdomain}.cybozu.com/k/v1/record.json"
#define APP_ID               999
#define API_TOKEN            "xxx"
#define BASIC64              "xxx"
#define DEMO_AP_SSID         "xxx"
#define DEMO_AP_SECUTIRY_KEY "xxx"
#define INTERVAL             60

#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"
#include "HTTPClient.h"
#include "SNIC_WifiInterface.h"

C12832 lcd(p5, p7, p6, p8, p11);
LM75B sensor(p28, p27);

#if defined(TARGET_LPC1768)
C_SNIC_WifiInterface     wifi( p9, p10, NC, NC, p30 );
#elif defined(TARGET_NUCLEO_F401RE) || defined(TARGET_NUCLEO_L152RE)
C_SNIC_WifiInterface     wifi( D8, D2, NC, NC, D3);
#elif defined(TARGET_K64F)
C_SNIC_WifiInterface     wifi( D1, D0, NC, NC, D2);
#endif
#define DEMO_AP_SECURITY_TYPE e_SEC_WPA2_AES



void display(char *message)
{
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("%s", message);
    wait(0.1);
}

void post(void)
{
    HTTPClient http;
    HTTPResult ret;
    char str[512];
    char message[128];

    HTTPText inText(str, 1024);

    char post_template[] = "{\"app\": %i, \"record\": {\"temp\": {\"value\": \"%.1f\"}}}\n";
    char header_template[] = "X-Cybozu-API-Token: %s\nContent-Type: application/json\n";
    char header_template_basic[] = "Authorization:Basic %s\nX-Cybozu-API-Token: %s\nContent-Type: application/json\n";
    char post_data[256];
    char header_data[256];
    
    // Basic Authentications
    if (BASIC64 != "") {
        sprintf(header_data, header_template_basic, BASIC64, API_TOKEN);
    } else {
        sprintf(header_data, header_template, API_TOKEN);
    }
    sprintf(post_data, post_template, APP_ID, (float)sensor);

    HTTPText outText(post_data, strlen(post_data));

    http.setHeader(header_data) ;
    http.setSSLversion(3) ; /* TLSv1.2 */
    ret = http.post(POST_URL, outText, &inText);
    if (ret == HTTP_OK) {
        sprintf(message, "OK: %s", str);
        display(message);
    } else {
        sprintf(message, "ERROR: %d", http.getHTTPResponseCode());
        display(message);
    }
}

int main()
{
    int check = 0;
    char message[128];

    // Initialize Wi-Fi interface
    check = wifi.init();
    if (check != 0) {
        display("Wifi could not be initialized");
        return -1;
    } else {
        display("wifi initialized successfully");
    }
    wait(0.5);

    // good form to make sure you are disconnected from all AP's
    check = wifi.disconnect();
    if (check != 0) {
        display("disconnect failed");
        return -1;
    } else {
        display("disconnection successful");
    }
    wait(0.3);

    // Connect AP
    wifi.connect( DEMO_AP_SSID
                  , strlen(DEMO_AP_SSID)
                  , DEMO_AP_SECURITY_TYPE
                  , DEMO_AP_SECUTIRY_KEY
                  , strlen(DEMO_AP_SECUTIRY_KEY) );
    wait(0.5);

    // Get DHCP IP
    check = wifi.setIPConfig(true);
    if (check != 0) {
        display("SetIPConfig failed");
        return -1;
    } else {
        display("SetIPConfig successful");
    }
    sprintf(message, "IP: %s", wifi.getIPAddress());
    display(message);

    while (true) {
        post();
        wait(INTERVAL);        
    }

    wifi.disconnect();
}