#include "mbed.h"
#include "nexpaq_mdk.h"
#include "MAX44000.h"
#include "pwm_tone.h"
 
//MAX44000 max44000(P1_6, P1_7);
//i2c code goes here////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
I2C i2c(P1_6,P1_7);
PwmOut ledR(P2_4);
PwmOut ledG(P2_5);
PwmOut ledB(P2_6);
PwmOut Buzzer(P1_2);
DigitalIn button(P0_1, PullUp);
//DigitalOut buz(P0_0);

//int buzzing=0;
 
/***** Definitions *****/
#define     FUNCTION_TABLE_NUM                  1
#define     UUID_NUM                            16          //UUID number is 16, don't change it
#define     LOOP_DELAY                          100
#define     PROX_THRESHOLD                      50
 
/***** Globals *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len);
const MDK_REGISTER_CMD my_cmd_func_table[FUNCTION_TABLE_NUM] = {
    {0x2700, my_function_CMD_2700},     // Command -> function
};
 int buzzing=0;
//int lastPrx = 0;
int toggle = 0;
unsigned char prxPress = 0x02;
int lastBtn = 1;
unsigned char btnPress = 0x01;
 
/***** Functions *****/
void my_function_CMD_2700(unsigned char *pData, unsigned char len)
{
    unsigned char response = 0x00;
    ledR = 1.0f - (pData[0] / 255.0f);
    ledG = 1.0f - (pData[1] / 255.0f);
    ledB = 1.0f - (pData[2] / 255.0f);
    toggle = pData[0];
    np_api_upload(0x2701, &response, 1);
}

int i2c_read_gesture(char gestReg)
{
    char    readVal;
    //char    gestReg;
 
    //gestReg    = 0x04;
 
    i2c.write( 0x20, &gestReg, 1 );
    i2c.read( 0x20, &readVal, 1 );
    
    //perform cast here 
    return( readVal );
}
 
/******************************************************************************/
void app_setup()
{
    if ( np_api_register((MDK_REGISTER_CMD*)my_cmd_func_table, FUNCTION_TABLE_NUM) == MDK_REGISTER_FAILD ) {
        // Register failed handle code
        error("MDK Register Failed");
    }
    //max44000.init(MAX44000::MODE_ALS_PROX, MAX44000::ALSTIM_64X, MAX44000::ALSPGA_1X, MAX44000::DRV_110);
    ledR = 1.0f;
    ledG = 1.0f;
    ledB = 1.0f;
    
    //buz = 0;
}
 
void app_loop()
{
    float A_4 = 1000000/Do4;
    //int proxData = max44000.readReg(MAX44000::REG_PRX_DATA);
    int gesture = i2c_read_gesture(0x04);
    
    if(!buzzing){
    if (gesture == 0x01) {
        if (!toggle) {
            np_api_upload(0x2800, &prxPress, 1);
            //int dummy = i2c_read_gesture(0x0a);
            //Stop_tunes(Buzzer);
            }
        toggle = 1;
        
    } else if (gesture == 0x02) {
        if(toggle){
        np_api_upload(0x2800, &prxPress, 1);
        }
    toggle = 0;}
    
    if(toggle){
        int distance = i2c_read_gesture(0x0a);
        if(distance<60){
        buzzing =1;}
        }
    
 
    if (!button && lastBtn) {
        np_api_upload(0x2800, &btnPress, 1);
    }
    }
    lastBtn = button;
    if(buzzing){
    	Tune(Buzzer, A_4, 4);  //4 Octave C beat 4/16
    	}
    if(buzzing &&!toggle){
    	buzzing=0;
    	//np_api_upload(0x2800, &prxPress, 1);
    	//toggle = 1;
    	}
}


 
int main(void)
{
 
    np_api_init();
    app_setup();
    np_api_start();
    while(1) {
        
        Thread::wait(LOOP_DELAY);
        app_loop();
        np_api_bsl_chk();
        
    }
 
    return 0;
}