/*
 * Copyright (c) 2015 ARM Limited. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __INCLUDE_STATIC_CONFIG__
#define __INCLUDE_STATIC_CONFIG__
#include "ns_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_HEAP_SIZE
#define MBED_MESH_API_HEAP_SIZE YOTTA_CFG_MBED_MESH_API_HEAP_SIZE
#elif defined MBED_CONF_MBED_MESH_API_HEAP_SIZE
#define MBED_MESH_API_HEAP_SIZE MBED_CONF_MBED_MESH_API_HEAP_SIZE
#else
#define MBED_MESH_API_HEAP_SIZE 32500
#endif

/*
 * Channel list is defined as 1 shifted by the channel number
 * f.e.:
 * channel 4 = 1<<4.
 * channel 10 = 1<<10
 *
 * Channel page.
 * -for scan channels 0-10 use value 2 = CHANNEL_PAGE_2
 * -for scan channels 11-26 use value 0 = CHANNEL_PAGE_0
 * Possible channels are 0,1,2,3,4,5,6,9,10, see arm_hal_phy.h for details
 */

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE MBED_CONF_MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE
#else
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_PAGE 0
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_CHANNEL
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_CHANNEL
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_CHANNEL
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL MBED_CONF_MBED_MESH_API_6LOWPAN_ND_CHANNEL
#else
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL 0
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK MBED_CONF_MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK
#elif defined MBED_MESH_API_6LOWPAN_ND_CHANNEL
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK (1<<MBED_MESH_API_6LOWPAN_ND_CHANNEL)
#else
#define MBED_MESH_API_6LOWPAN_ND_CHANNEL_MASK (1<<12) // Why 12? Why not default channel value?
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE
#define MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE
#define MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE MBED_CONF_MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE
#else
#define YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_SECURITY_MODE NONE
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID
#define MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID
#define MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID MBED_CONF_MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID
#else
#define MBED_MESH_API_6LOWPAN_ND_PSK_KEY_ID 1
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_PSK_KEY
#define MBED_MESH_API_6LOWPAN_ND_PSK_KEY YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_PSK_KEY
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_PSK_KEY
#define MBED_MESH_API_6LOWPAN_ND_PSK_KEY MBED_CONF_MBED_MESH_API_6LOWPAN_ND_PSK_KEY
#else
#define MBED_MESH_API_6LOWPAN_ND_PSK_KEY {0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf}
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL
#define MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL YOTTA_CFG_MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL
#elif defined MBED_CONF_MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL
#define MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL MBED_CONF_MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL
#else
#define MBED_MESH_API_6LOWPAN_ND_SEC_LEVEL 5
#endif

/* Thread configuration */
// PSKd, must be longer than 6
#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_PSKD
#define MBED_MESH_API_THREAD_PSKD YOTTA_CFG_MBED_MESH_API_THREAD_PSKD
#elif defined MBED_CONF_MBED_MESH_API_THREAD_PSKD
#define MBED_MESH_API_THREAD_PSKD MBED_CONF_MBED_MESH_API_THREAD_PSKD
#else
#define MBED_MESH_API_THREAD_PSKD "Secret password"
#endif

// Operating mode, values: Router, SED
#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_DEVICE_TYPE
#define MBED_MESH_API_THREAD_DEVICE_TYPE YOTTA_CFG_MBED_MESH_API_THREAD_DEVICE_TYPE
#elif defined MBED_CONF_MBED_MESH_API_THREAD_DEVICE_TYPE
#define MBED_MESH_API_THREAD_DEVICE_TYPE MBED_CONF_MBED_MESH_API_THREAD_DEVICE_TYPE
#else
#define MBED_MESH_API_THREAD_DEVICE_TYPE MESH_DEVICE_TYPE_THREAD_ROUTER
#endif

// channel mask, enable all channels
#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK
#elif defined MBED_CONF_MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK MBED_CONF_MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK
#else
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL_MASK 0x07fff800
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE
#elif defined MBED_CONF_MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE MBED_CONF_MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE
#else
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL_PAGE 0
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_CHANNEL
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_CHANNEL
#elif defined MBED_CONF_MBED_MESH_API_THREAD_CONFIG_CHANNEL
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL MBED_CONF_MBED_MESH_API_THREAD_CONFIG_CHANNEL
#else
#define MBED_MESH_API_THREAD_CONFIG_CHANNEL 12
#endif

// Default PANID
#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_PANID
#define MBED_MESH_API_THREAD_CONFIG_PANID YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_PANID
#elif defined MBED_CONF_MBED_MESH_API_THREAD_CONFIG_PANID
#define MBED_MESH_API_THREAD_CONFIG_PANID MBED_CONF_MBED_MESH_API_THREAD_CONFIG_PANID
#else
#define MBED_MESH_API_THREAD_CONFIG_PANID 0xDEFA // 57082
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_MASTER_KEY
#define MBED_MESH_API_THREAD_MASTER_KEY YOTTA_CFG_MBED_MESH_API_THREAD_MASTER_KEY
#elif defined MBED_CONF_MBED_MESH_API_THREAD_MASTER_KEY
#define MBED_MESH_API_THREAD_MASTER_KEY MBED_CONF_MBED_MESH_API_THREAD_MASTER_KEY
#else
#define MBED_MESH_API_THREAD_MASTER_KEY {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff}
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_ML_PREFIX
#define MBED_MESH_API_THREAD_CONFIG_ML_PREFIX YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_ML_PREFIX
#elif defined MBED_CONF_MBED_MESH_API_THREAD_CONFIG_ML_PREFIX
#define MBED_MESH_API_THREAD_CONFIG_ML_PREFIX MBED_CONF_MBED_MESH_API_THREAD_CONFIG_ML_PREFIX
#else
#define MBED_MESH_API_THREAD_CONFIG_ML_PREFIX {0xfd, 0x00, 0x0d, 0xb8, 0x00, 0x00, 0x00, 0x00}
#endif

#ifdef YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_PSKC
#define MBED_MESH_API_THREAD_CONFIG_PSKC YOTTA_CFG_MBED_MESH_API_THREAD_CONFIG_PSKC
#elif defined MBED_CONF_MBED_MESH_API_THREAD_CONFIG_PSKC
#define MBED_MESH_API_THREAD_CONFIG_PSKC MBED_CONF_MBED_MESH_API_THREAD_CONFIG_PSKC
#else
#define MBED_MESH_API_THREAD_CONFIG_PSKC {0x00, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88, 0x99, 0xaa, 0xbb, 0xcc, 0xdd, 0xee, 0xff}
#endif

#ifdef __cplusplus
}
#endif
#endif /* __INCLUDE_STATIC_CONFIG__ */
