#include "mbed.h"
#include "MMA8452.h"
#include "uLCD_4DGL.h"


#include "ScreenObject.h"
#include "SpaceShipEarth.h"

#define SCREEN_CENTER 59

double ax, ay, az;                  // accelerometer readings 

Serial pc(USBTX, USBRX, 9600);
MMA8452 acc(p28, p27, 100000);
uLCD_4DGL lcd(p9, p10, p11);

bool overlap(ScreenObject & objectA, ScreenObject & objectB);


bool overlap(ScreenObject & objectA, ScreenObject & objectB) {
    return true;
}

int main() {
    lcd.baudrate(300000);
    srand(time(NULL));
    SpaceShipEarth spe;
    ScreenObject* earth = &spe;
    while (1) {
        acc.readXYZGravity(&ay, &ax, &az);
        int newy = (int) SCREEN_CENTER + 70 * ay;
        int newx = (int) SCREEN_CENTER + 70 * ax;
//        pc.printf("%d, %d\n", newx, newy);
        earth->update(newx, newy);
        wait(0.08);
    }
}

