#include "mbed.h"

#include "LinearMotor.h"

int ItvTable[200]= {5000,3219,2373,1880,1556,1327,1157,1026,921,836,765,706,654,610,572,538,507,480,456,434,414,396,380,364,350,337,325,314,303,293,284,275,267,260,252,246,239,233,227,221,216,211,206,202,197,193,189,185,181,178,174,171,168,165,162,159,156,154,151,149,146,144,142,139,137,135,133,131,129,128,126,124,122,121,119,118,116,115,113,112,110,109,108,107,105,104,103,102,101,100,98,97,96,95,94,93,92,91,91,90,89,88,87,86,85,85,84,83,82,82,81,80,79,79,78,77,77,76,75,75,74,74,73,72,72,71,71,70,70,69,69,68,68,67,67,66,66,65,65,64,64,63,63,62,62,62,61,61,60,60,60,59,59,58,58,58,57,57,57,56,56,56,55,55,54,54,54,54,53,53,53,52,52,52,51,51,51,51,50,50,50,49,49,49,49,48,48,48,48,47,47,47,47,46,46,46,46,45,45,45};
int stepTable[200]= {2,5,9,14,20,28,37,47,58,70,83,97,112,128,145,164,184,205,227,250,274,299,325,352,381,411,442,474,507,541,576,612,649,687,727,768,810,853,897,942,988,1035,1084,1134,1185,1237,1290,1344,1399,1455,1512,1570,1630,1691,1753,1816,1880,1945,2011,2078,2146,2215,2285,2357,2430,2504,2579,2655,2733,2811,2890,2971,3053,3136,3220,3305,3391,3478,3566,3655,3746,3838,3931,4024,4119,4215,4312,4410,4509,4609,4711,4814,4918,5023,5129,5237,5346,5456,5566,5677,5789,5903,6018,6134,6252,6370,6489,6609,6731,6853,6976,7101,7228,7355,7483,7613,7743,7875,8008,8141,8276,8411,8548,8687,8826,8967,9108,9251,9394,9539,9684,9831,9978,10127,10276,10428,10580,10734,10888,11044,11200,11359,11518,11679,11840,12001,12165,12329,12496,12663,12830,12999,13168,13340,13512,13684,13859,14034,14209,14388,14567,14746,14928,15110,15295,15480,15665,15850,16039,16228,16417,16609,16801,16993,17189,17385,17581,17777,17977,18177,18377,18581,18785,18989,19193,19401,19609,19817,20025,20238,20451,20664,20877,21094,21311,21528,21745,21967,22189,22411};


Serial pc(SERIAL_TX, SERIAL_RX);

//0.00225mm/step
//500usec=4.5mm/sec
//45usec=50mm/sec
LinearMotor lm(PA_7,PA_6,PA_5,PA_0);
void move(double dis, double spd);
void init(void);

void pause(void);
InterruptIn psw(PA_8);
DigitalIn psw_(PA_8);
int main() {

    psw_.mode(PullUp);
    pc.baud(230400);
    if(psw_.read()) pc.printf("\n\rPause....                  ");
    while(psw_.read());
    pc.printf("Start");        
    wait_ms(20);
    
    psw.rise(&pause);
    lm.st=1;
    wait_ms(500);   
    init();
    wait_ms(500);
    while(1) {
        move(50,10);
        wait_ms(200);
        move(-50,10);
        wait_ms(200);
    }
}


void move(double dis, double spd){//spd mm/sec
    pc.printf("Moving %10fmm at %10fmm/sec...    ",dis,spd);
    int j=0;
    int crntDly=5000;
    int i;
    
    if (dis>0)lm.dir=1;
    else{ 
        lm.dir=0;
        dis=-dis;
    }
    
    int stepDly=(int)(0.5+2250/spd);
    int step=(int)(0.5+dis/0.00225);
    if (stepDly>=ItvTable[0]){
        for(i=0;i<step;i++){
            lm.pulse=!lm.pulse;
            wait_us(stepDly);           
        }
    }
    else{
        int ihigh=0;
        for(i=0;i<(int)(step/2);i++){
            lm.pulse=!lm.pulse;
            if(j>=200 || crntDly<=stepDly){crntDly=stepDly;}
            else if(i<stepTable[j]){crntDly=ItvTable[j];}
            else {j++;ihigh=i;}
            wait_us(crntDly);           
        }  
        for(i=(int)(step/2);i>0;i--){
            lm.pulse=!lm.pulse;
            if(i>=ihigh){crntDly=stepDly;}
            else if(j<=0 || crntDly>=ItvTable[0]){crntDly=ItvTable[0];}
            else if(i>=stepTable[j]){crntDly=ItvTable[j];}
            else {j--;}
            wait_us(crntDly);     
        }     
    }  
    pc.printf("Complete\n\r");
}


void init(void){
    lm.dir=0;
    int i=0;
    int j=0;
    int crntDly=5000;
    int stepDly=(int)(0.5+2250/10);
    pc.printf("\n\rInitializing...                               ");
    while(lm.limit==0){
        lm.pulse=!lm.pulse;
        if(j>=200 || crntDly<=stepDly){crntDly=stepDly;}
        else if(i<stepTable[j]){crntDly=ItvTable[j];}
        else {j++;}
        wait_us(crntDly);  
        i++;
    }
    pc.printf("Complete\n\r");
}

void pause(void){
    psw.disable_irq();
    wait_ms(20);
    pc.printf("\n\rPause....");
    while(psw_.read());
    pc.printf("                  Resume\n\r");
    psw.enable_irq();
}