#include "mbed.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "OLED_types.h"
#include "OpenSans_Font.h"
#include "string.h"
#include "images.h"

#define LED_ON      0
#define LED_OFF     1

void ReadCommand();
void homescreen();

void StartHaptic(void);
void StopHaptic(void const *n);
DigitalOut haptic(PTB9);
RtosTimer hapticTimer(StopHaptic, osTimerOnce);

Serial pc(USBTX, USBRX, 115200);
//Serial BT(PTC17, PTC16, 115200);
KW40Z kw40z_device(PTE24, PTE25);
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15);

BusIn MusicCommand(PTA10, PTB13, PTD2);
InterruptIn que(PTD3);

DigitalOut listeningLED(LED1, 1);

DigitalOut volumeup(PTA4);
DigitalOut nextsong(PTB7);
DigitalOut pause_play(PTB6);
DigitalOut lastsong(PTC17);
DigitalOut volumedown(PTD8);

char text[20];

int y;

void ReadCommand()
{
    while(1)
    {
        listeningLED = 0;
        wait(.5);
        y = MusicCommand.read();
    
        if (y == 0)//volume up
        {
            volumeup.write(0);
            wait(0.1);
            volumeup.write(1);
            wait(0.1);
            volumeup.write(0);
            wait(0.1);
            volumeup.write(1);
            wait(0.1);
            volumeup.write(0);
            wait(0.1);
            volumeup.write(1);
            listeningLED = 1;
            break;
        }
        if (y == 1)//next song
        {
            nextsong.write(0);
            wait(0.1);
            nextsong.write(1);
            listeningLED = 1;
            break;
        }
        if (y == 2)//pause
        {
            pause_play.write(0);
            wait(0.1);
            pause_play.write(1);
            listeningLED = 1;
            break;
        }
        if (y == 3)//play
        {
            pause_play.write(0);
            wait(0.1);
            pause_play.write(1);
            listeningLED = 1;
            break;
        }
        if (y == 4)//restart
        {
            lastsong.write(0);
            wait(0.1);
            lastsong.write(1);
            listeningLED = 1;
            break;
        }
        if (y == 5)//volume down
        {
            volumedown.write(0);
            wait(0.1);
            volumedown.write(1);
            wait(0.1);
            volumedown.write(0);
            wait(0.1);
            volumedown.write(1);
            wait(0.1);
            volumedown.write(0);
            wait(0.1);
            volumedown.write(1);
            listeningLED = 1;
            break;
        }
        if (y == 6)//last song
        {
            lastsong.write(0);
            wait(0.1);
            lastsong.write(1);
            wait(0.1);
            lastsong.write(0);
            wait(0.1);
            lastsong.write(1);
            listeningLED = 1;
            break;
        }
    }
}

void homescreen()
{
    oled.DimScreenON();
    const uint8_t *image1;
    image1  = NXP_whole_bmp;
    oled.FillScreen(COLOR_WHITE);
    oled.DrawImage(image1,0,0);        
    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties); 
    textProperties.fontColor   = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);
    strcpy((char *) text,"Welcome to");
    oled.Label((uint8_t *)text,15,30);
    strcpy((char *) text,"HexiHub");
    oled.Label((uint8_t *)text,20,45);   
    strcpy((char *) text,"Prev.");
    oled.Label((uint8_t *)text,0,0);    
    strcpy((char *) text,"Pause");
    oled.Label((uint8_t *)text,0,80);   
    strcpy((char *) text,"Play");
    oled.Label((uint8_t *)text,74,80);    
    strcpy((char *) text,"Next");
    oled.Label((uint8_t *)text,72,0);
}

void ButtonUp(void)
{
    StartHaptic();
    nextsong.write(0);
    wait(0.1);
    nextsong.write(1);
}

void ButtonDown(void)
{
    StartHaptic();
    lastsong.write(0);
    wait(0.1);
    lastsong.write(1);
}

void ButtonRight(void)
{
    StartHaptic();
 
    pause_play.write(0);
            wait(0.1);
            pause_play.write(1);
    
}

void ButtonLeft(void)
{
    StartHaptic();
    volumeup.write(0);
    wait(0.1);
    volumeup.write(1);
}

int main()
{  
    homescreen();

    que.rise(&ReadCommand);
    que.fall(&ReadCommand);
    
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    
   // while(1) 
    //{
      //  pc.putc(BT.getc());
   // }    
}

void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
}


//SCREEN CHANGES

/*
oled.DimScreenON();
const uint8_t *image1;
image1  = NXP_whole_bmp;
oled.FillScreen(COLOR_WHITE);
oled.DrawImage(image1,0,0);        
oled_text_properties_t textProperties = {0};
oled.GetTextProperties(&textProperties); 
textProperties.fontColor   = COLOR_WHITE;
textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
oled.SetTextProperties(&textProperties);
strcpy((char *) text,"NEXT");
oled.Label((uint8_t *)text,15,30);
*/
            
