/* Test of FRDM-KL25z RGB LED and Serial out to PC.
 * This program blinks the LED through the series of colors
 * red, greeen, and blue, displaying each for 1 second, with
 * a 1 second off period between each color. As it makes each 
 * change in the status of the LED, it sends a message to the 
 * pc serial port over the USB programming connection. The 
 * pattern repeats 5 times, then two short white flashes are 
 * displayed by turning all threee LEDs on and off at once, and
 * a final message is sent to the serial port.
 *
 * Tested from OSX 10.8.4. To find the serial port device, 
 * launch Terminal, then type:
 * 
 * ls /dev/tty.usbmodem* 
 *
 * It will return something like /dev/tty.usbmodem1d22
 * To change Terminal to connect to the serial port, use the screen
 * command, specifying the path returned by ls and the baud rate:
 *
 * screen /dev/tty.usbmodem1d22 9600
 * 
 * As a shortcut, if you have just one serial device connected, you
 * can skip the first command and type the second command as far as 
 * tty.usb and hit the tab key and it will autocomplete. 
 * Once screen is running, type Ctrl-a then ? for a list of available 
 * commands.
 */
 
#include "mbed.h"

DigitalOut redLED(LED_RED);               // Define digital outputs for each LED color
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);
Serial pc(USBTX, USBRX);                  // Declare the serial port

int main() {
    pc.baud (9600);                       // Set the baud rate for the serial connection
    redLED = 1;                           // This a common anode RGB LED, with the anodes connected
    greenLED = 1;                         // to 1. Thus, to turn a color off you counterintuitively set
    blueLED = 1;                          // it to 1, so there is no voltage difference across the LED
    for (int i = 1; i <= 5; i++) {        // Do 5 times:
       redLED = 0;                        // Turn the red LED on
       pc.printf("Red LED ON \n\r");      // Send a status message
       wait(1.0);                         // Wait 1.0 seconds
       redLED = 1;                        // Turn the red LED off
       pc.printf("Red LED OFF \n\r");     // Send a status message
       wait(1.0);                         // Wait 1.0 seconds
       greenLED = 0;                      // Repeat the above for the green LED
       pc.printf("Green LED ON \n\r"); 
       wait(1.0);
       greenLED = 1;
       pc.printf("Green LED OFF \n\r");
       wait(1.0);
       blueLED = 0;                       // Repeat for the blue LED
       pc.printf("Blue LED ON \n\r"); 
       wait(1.0);
       blueLED = 1;
       pc.printf("Blue LED OFF \n\r");
       wait(1.0);
   }
   redLED = greenLED = blueLED = 0;       // Give a short double-flash of white
   wait(0.25);
   redLED = greenLED = blueLED = 1;
   wait(0.25);
   redLED = greenLED = blueLED = 0;
   wait(0.25);
   redLED = greenLED = blueLED = 1;       // Leave the LED off at the end
   pc.printf("Goodbye \n\r");             // Send a farewell message  
}