/**********************************************************************
* Written by WAVToCode
* Date:             Thu Nov 17 06:08:59 PM
* FileName:         sample4.C
* Interleaved:      N/A
* Signed:           No
* No. of channels:  1
* No. of samples:   4937
* Bits/Sample:      16
**********************************************************************/

#define RICOCHET_NUM_ELEMENTS 4937

const unsigned short ricochet_sound_data[RICOCHET_NUM_ELEMENTS] = { 
33024, 33536, 34560, 36352, 38144, 38912, 38912, 38400, /* 0-7 */
38400, 37376, 36096, 32768, 27392, 22528, 19456, 18176, /* 8-15 */
18176, 18944, 19968, 20992, 22272, 23552, 24576, 25856, /* 16-23 */
27904, 32000, 37888, 41984, 44032, 44288, 43776, 42752, /* 24-31 */
41472, 40448, 39168, 37376, 33792, 28672, 24320, 22016, /* 32-39 */
20992, 20992, 22272, 24064, 26368, 28672, 30208, 30976, /* 40-47 */
30720, 30464, 30464, 29184, 27648, 26880, 26368, 26368, /* 48-55 */
27136, 27904, 29184, 30464, 33024, 35584, 37888, 39936, /* 56-63 */
41984, 43264, 44800, 45312, 45312, 44800, 44288, 43264, /* 64-71 */
41216, 39168, 35584, 29440, 25088, 22784, 22016, 21504, /* 72-79 */
22272, 23808, 25088, 26368, 28672, 31488, 34560, 38656, /* 80-87 */
43520, 45568, 44800, 44032, 42240, 40704, 38656, 34816, /* 88-95 */
29952, 26880, 24576, 23296, 22528, 21504, 22016, 23296, /* 96-103 */
23808, 25344, 26368, 27392, 29696, 32256, 34816, 37632, /* 104-111 */
41472, 44032, 43776, 44288, 45056, 44032, 40960, 37888, /* 112-119 */
34304, 30976, 28672, 27136, 25600, 26368, 27648, 28416, /* 120-127 */
30208, 32768, 35072, 37376, 38912, 38656, 36864, 34560, /* 128-135 */
33280, 32000, 30464, 30720, 31232, 30976, 28416, 25088, /* 136-143 */
24320, 25344, 26880, 27136, 27136, 30208, 35840, 37888, /* 144-151 */
38144, 39168, 39168, 38656, 39936, 41984, 43264, 42496, /* 152-159 */
40960, 40192, 39424, 39168, 39168, 37888, 32768, 28160, /* 160-167 */
29696, 31232, 27136, 23040, 20992, 18944, 18176, 18688, /* 168-175 */
21760, 24576, 24832, 24576, 25856, 27904, 30976, 34304, /* 176-183 */
35072, 35584, 37376, 39424, 39680, 36864, 36352, 39424, /* 184-191 */
41984, 41216, 39168, 37120, 37120, 38400, 38144, 34304, /* 192-199 */
29952, 29440, 30720, 32256, 32256, 30464, 27136, 26112, /* 200-207 */
28160, 30720, 32256, 32256, 31488, 30976, 31488, 32256, /* 208-215 */
32256, 31232, 30720, 30720, 31744, 32256, 31744, 32000, /* 216-223 */
32000, 31232, 31232, 31744, 33024, 34048, 33536, 33536, /* 224-231 */
33024, 32768, 32000, 32000, 33280, 32768, 32768, 33024, /* 232-239 */
33536, 34816, 36608, 38912, 42240, 41984, 37120, 30976, /* 240-247 */
28672, 31232, 36864, 36864, 33024, 31744, 32256, 37120, /* 248-255 */
41216, 39424, 36608, 34304, 38400, 45824, 46336, 41472, /* 256-263 */
35072, 34304, 39680, 42240, 38400, 34560, 30976, 32256, /* 264-271 */
36608, 33792, 32000, 28928, 24576, 29696, 32768, 33280, /* 272-279 */
31744, 23552, 23040, 26368, 29952, 32256, 27136, 25600, /* 280-287 */
27392, 30208, 35584, 32768, 32768, 31744, 27904, 34048, /* 288-295 */
36608, 38656, 39680, 30464, 28160, 31232, 35840, 40704, /* 296-303 */
33280, 29184, 33280, 31232, 37376, 41472, 34816, 34816, /* 304-311 */
32768, 29696, 36864, 36864, 37632, 39680, 30208, 26624, /* 312-319 */
29696, 32000, 39424, 34816, 27392, 29952, 29952, 30720, /* 320-327 */
36608, 35840, 30720, 30208, 28928, 27392, 34304, 36864, /* 328-335 */
35328, 37888, 34048, 27904, 30464, 35328, 38144, 36096, /* 336-343 */
32768, 31744, 33024, 35072, 36608, 39424, 39424, 30720, /* 344-351 */
30464, 31488, 26624, 34048, 39168, 30464, 30976, 35840, /* 352-359 */
27392, 24320, 33024, 36352, 29440, 29184, 31744, 25088, /* 360-367 */
26880, 34816, 32000, 32768, 38144, 30720, 28672, 31488, /* 368-375 */
28416, 32768, 38912, 34816, 28928, 35072, 35072, 25088, /* 376-383 */
28160, 38144, 35840, 27392, 33024, 33024, 23296, 29440, /* 384-391 */
38656, 32256, 29952, 40192, 34304, 27392, 33536, 30464, /* 392-399 */
29184, 36608, 38144, 28416, 30720, 38144, 28160, 24832, /* 400-407 */
35328, 41216, 32256, 27648, 36608, 29952, 23296, 34048, /* 408-415 */
38912, 29184, 27392, 37888, 32000, 24064, 28416, 28672, /* 416-423 */
27648, 29184, 35072, 30720, 27136, 36608, 31744, 25856, /* 424-431 */
30464, 37376, 39168, 28928, 29440, 35072, 25856, 25856, /* 432-439 */
35328, 37120, 28672, 29696, 39680, 32768, 26112, 29952, /* 440-447 */
30976, 32000, 29696, 34304, 34560, 27904, 34560, 34816, /* 448-455 */
28928, 31488, 35328, 41728, 37632, 28160, 35840, 34048, /* 456-463 */
25344, 30208, 39424, 39424, 28672, 31488, 42496, 32256, /* 464-471 */
25856, 32000, 33536, 34816, 28928, 30720, 37120, 27392, /* 472-479 */
28928, 33536, 28928, 31488, 30464, 35584, 41216, 28160, /* 480-487 */
28672, 35584, 24832, 24064, 31744, 37888, 34816, 24576, /* 488-495 */
34048, 39680, 25600, 24064, 28416, 30464, 37632, 28928, /* 496-503 */
26368, 36608, 29440, 25856, 29696, 29440, 36608, 33280, /* 504-511 */
30208, 42752, 36352, 25856, 34048, 30464, 24320, 29440, /* 512-519 */
32768, 39936, 36352, 27904, 38912, 39680, 26368, 26368, /* 520-527 */
28928, 34048, 42752, 34304, 24832, 34560, 36864, 28160, /* 528-535 */
25600, 31232, 40448, 40448, 30720, 36096, 43264, 31232, /* 536-543 */
25600, 31744, 27904, 29952, 35840, 33280, 37120, 36096, /* 544-551 */
29696, 36864, 40448, 35328, 37376, 37632, 38656, 50432, /* 552-559 */
47872, 30464, 33280, 38912, 17152,   0, 3072, 9216, /* 560-567 */
16640, 12544, 5632, 18944, 25856, 13568, 14848, 20992, /* 568-575 */
20992, 37632, 48384, 42752, 52480, 60928, 51456, 51712, /* 576-583 */
55040, 43776, 37376, 34816, 29440, 38656, 44800, 33024, /* 584-591 */
30464, 40704, 34816, 25856, 30208, 36096, 44544, 44032, /* 592-599 */
31488, 35584, 48128, 35584, 14080, 12032, 12544, 14080, /* 600-607 */
24320, 20992, 14080, 26112, 33024, 24320, 25856, 31488, /* 608-615 */
31744, 37632, 35584, 23296, 29440, 37376, 25088, 23808, /* 616-623 */
34560, 24576, 18176, 30208, 32256, 34048, 41472, 33536, /* 624-631 */
27136, 37888, 40960, 26368, 24832, 35072, 34048, 40448, /* 632-639 */
48128, 35584, 28416, 41984, 43776, 29440, 29696, 33536, /* 640-647 */
32000, 39680, 37120, 23296, 31744, 47360, 37376, 30720, /* 648-655 */
44288, 40192, 29952, 41984, 42496, 32000, 41984, 46848, /* 656-663 */
35328, 38656, 49920, 40192, 30208, 39424, 38400, 33024, /* 664-671 */
41984, 40704, 26368, 29696, 42496, 36608, 25856, 30208, /* 672-679 */
34560, 38912, 47360, 39680, 26368, 33792, 41216, 27648, /* 680-687 */
18432, 27648, 27392, 26624, 37888, 31744, 20480, 30464, /* 688-695 */
39424, 27136, 22784, 34560, 32000, 22016, 29440, 31488, /* 696-703 */
22528, 31232, 41984, 31488, 24576, 38400, 44032, 28928, /* 704-711 */
26880, 37120, 35840, 37632, 40960, 28672, 23808, 36864, /* 712-719 */
40192, 23040, 16384, 26880, 26368, 24576, 35584, 31232, /* 720-727 */
16896, 22272, 36352, 30464, 21760, 30208, 33536, 27136, /* 728-735 */
36608, 40960, 28928, 29952, 44544, 42752, 28672, 33280, /* 736-743 */
43776, 33792, 26368, 37888, 38912, 31488, 42240, 44800, /* 744-751 */
30720, 32768, 45568, 42752, 26624, 26112, 37632, 32768, /* 752-759 */
30464, 42496, 39680, 24064, 26368, 40192, 35584, 22272, /* 760-767 */
28672, 36096, 30208, 34560, 41984, 31232, 24064, 36352, /* 768-775 */
44544, 34304, 25600, 36608, 39936, 26112, 29696, 42496, /* 776-783 */
34560, 28160, 40704, 40960, 26624, 29440, 42240, 38912, /* 784-791 */
25088, 28672, 39680, 31488, 25600, 38656, 41728, 27648, /* 792-799 */
24064, 37120, 37632, 22784, 23296, 36608, 35328, 32000, /* 800-807 */
43776, 42240, 30464, 35840, 46592, 42496, 28160, 28672, /* 808-815 */
42240, 36864, 26112, 37120, 44800, 31488, 28928, 41728, /* 816-823 */
38400, 24832, 30464, 44032, 36864, 22016, 29440, 37632, /* 824-831 */
29184, 29184, 39168, 37888, 23552, 19712, 34560, 37120, /* 832-839 */
21504, 17920, 28160, 29440, 28416, 39168, 39424, 22784, /* 840-847 */
21504, 37120, 41216, 29440, 20736, 28416, 34816, 27904, /* 848-855 */
32768, 46080, 39168, 24320, 29952, 40192, 35328, 28160, /* 856-863 */
34304, 40960, 32000, 28416, 42240, 42240, 29184, 32256, /* 864-871 */
41216, 38144, 25344, 22528, 37376, 40192, 23552, 20992, /* 872-879 */
34304, 32256, 30976, 41984, 40448, 31232, 30464, 36608, /* 880-887 */
41472, 32256, 20224, 28416, 36608, 29440, 31744, 43008, /* 888-895 */
43776, 34816, 28160, 34560, 39936, 29952, 22272, 32000, /* 896-903 */
37376, 32256, 38912, 44032, 28928, 21504, 33280, 41728, /* 904-911 */
36864, 24064, 20480, 30720, 34560, 24320, 25600, 40192, /* 912-919 */
36864, 24576, 33280, 37376, 27904, 29696, 38656, 39936, /* 920-927 */
34304, 24320, 20992, 31488, 34560, 28160, 34816, 43520, /* 928-935 */
35840, 20224, 24576, 39168, 36864, 24832, 25344, 32000, /* 936-943 */
31232, 32768, 39936, 39680, 29952, 26112, 33536, 40960, /* 944-951 */
36864, 21504, 17408, 32000, 40960, 30976, 27392, 40704, /* 952-959 */
38400, 22016, 26624, 40448, 35072, 25856, 32768, 38912, /* 960-967 */
30720, 24320, 28416, 37888, 36608, 27904, 29440, 37632, /* 968-975 */
39680, 28160, 18944, 31488, 43520, 35072, 19200, 23040, /* 976-983 */
37376, 33024, 30208, 43008, 41984, 26880, 27904, 42496, /* 984-991 */
43008, 28416, 19712, 22528, 33280, 36352, 29952, 33024, /* 992-999 */
40960, 37888, 26624, 23040, 32768, 37888, 33792, 28672, /* 1000-1007 */
28416, 38400, 38912, 31488, 38912, 43776, 33024, 25344, /* 1008-1015 */
35584, 46592, 31488, 14848, 21760, 36096, 36864, 24576, /* 1016-1023 */
20224, 33280, 37376, 29440, 31488, 37376, 37120, 29696, /* 1024-1031 */
31744, 44288, 39168, 26112, 20224, 19712, 28672, 33280, /* 1032-1039 */
30976, 36608, 39168, 36864, 27904, 17920, 24832, 33536, /* 1040-1047 */
29696, 26880, 27392, 33280, 39680, 36352, 36608, 38656, /* 1048-1055 */
32000, 29952, 35840, 42752, 43520, 27392, 15872, 28160, /* 1056-1063 */
37888, 28416, 22784, 35072, 46848, 38912, 26880, 31744, /* 1064-1071 */
38912, 33024, 26880, 32256, 44544, 46592, 31744, 22272, /* 1072-1079 */
31488, 37632, 27904, 25856, 40192, 50432, 41984, 25088, /* 1080-1087 */
25088, 40192, 37120, 23040, 23040, 26880, 34048, 41216, /* 1088-1095 */
39168, 40192, 42496, 31232, 24320, 31744, 37376, 37888, /* 1096-1103 */
32000, 22016, 28672, 37632, 25856, 20480, 30464, 33280, /* 1104-1111 */
35584, 35072, 28672, 33280, 35328, 27648, 30208, 30720, /* 1112-1119 */
24576, 33280, 36864, 28416, 38912, 44032, 27904, 27392, /* 1120-1127 */
36352, 35072, 37376, 32768, 20480, 30464, 42240, 32256, /* 1128-1135 */
28416, 26624, 19712, 34816, 42752, 24320, 29440, 44288, /* 1136-1143 */
36864, 34816, 35328, 32000, 40192, 36352, 10496, 13568, /* 1144-1151 */
38400, 34816, 31232, 41984, 36096, 36608, 39168, 20992, /* 1152-1159 */
21504, 42240, 37120, 27904, 32256, 30720, 37632, 48640, /* 1160-1167 */
34048, 26368, 47104, 39936, 16384, 32256, 48128, 40704, /* 1168-1175 */
36096, 23296, 18176, 42752, 47104, 17152, 12800, 36864, /* 1176-1183 */
41728, 38912, 39936, 29696, 28160, 43264, 36608, 19968, /* 1184-1191 */
34816, 48896, 37376, 29440, 25344, 21760, 36352, 44288, /* 1192-1199 */
23808, 23040, 50176, 44288, 20992, 25856, 35840, 36352, /* 1200-1207 */
38912, 27136, 14592, 30208, 47104, 32256, 22272, 40704, /* 1208-1215 */
45824, 36096, 35584, 31744, 24576, 35072, 41984, 20480, /* 1216-1223 */
9216, 30464, 43008, 36096, 32768, 28672, 30464, 46848, /* 1224-1231 */
45568, 17152, 13312, 40448, 38912, 22528, 33792, 41216, /* 1232-1239 */
34304, 34304, 30976, 21760, 31488, 45056, 32256, 19456, /* 1240-1247 */
37632, 47616, 35328, 32000, 31744, 22784, 27904, 41216, /* 1248-1255 */
29696, 10240, 21760, 43264, 41728, 37376, 38912, 33280, /* 1256-1263 */
35072, 42240, 32256, 20480, 31744, 43264, 30208, 22272, /* 1264-1271 */
34048, 35072, 23552, 26624, 37632, 39424, 41216, 41984, /* 1272-1279 */
28928, 23296, 39424, 39680, 22528, 26368, 40448, 34816, /* 1280-1287 */
25856, 36352, 40960, 31488, 33280, 41728, 33792, 28928, /* 1288-1295 */
42240, 38144, 24832, 28160, 32768, 25856, 21760, 29184, /* 1296-1303 */
30720, 24832, 35840, 46848, 28672, 13568, 30720, 47616, /* 1304-1311 */
36352, 24832, 29952, 37632, 45568, 45568, 26624, 10752, /* 1312-1319 */
24576, 44544, 32768, 13312, 26368, 47872, 42496, 33280, /* 1320-1327 */
36608, 28928, 24064, 37888, 37888, 22272, 22528, 38912, /* 1328-1335 */
40704, 24320, 24320, 43008, 47872, 42240, 44288, 34048, /* 1336-1343 */
14848, 24576, 45568, 37888, 14848, 12544, 32000, 41216, /* 1344-1351 */
37120, 33792, 24320, 24064, 42240, 49920, 30720, 12800, /* 1352-1359 */
26112, 44288, 35584, 28416, 38656, 42240, 32768, 29184, /* 1360-1367 */
32000, 28672, 29952, 37376, 37120, 25856, 24320, 42752, /* 1368-1375 */
46080, 32256, 30208, 30464, 24320, 23552, 32256, 35072, /* 1376-1383 */
20736, 12544, 28160, 39936, 38912, 39936, 40704, 35584, /* 1384-1391 */
32256, 36864, 36096, 26624, 25344, 31744, 33280, 26880, /* 1392-1399 */
28672, 37376, 30464, 18688, 25088, 40704, 45312, 40448, /* 1400-1407 */
36608, 31232, 26624, 34560, 40192, 29184, 21504, 32768, /* 1408-1415 */
43776, 33792, 22272, 32256, 39680, 34560, 30208, 34560, /* 1416-1423 */
35072, 28416, 37120, 43776, 30464, 24064, 29696, 34816, /* 1424-1431 */
30208, 19456, 22272, 28928, 28160, 34816, 44288, 39424, /* 1432-1439 */
24576, 22016, 38144, 45056, 33024, 25856, 31488, 39168, /* 1440-1447 */
40704, 40704, 34048, 17920, 17408, 35328, 40448, 25344, /* 1448-1455 */
18944, 36096, 48128, 37632, 30464, 35584, 30464, 24320, /* 1456-1463 */
30976, 37120, 29952, 23040, 31488, 41472, 33024, 19968, /* 1464-1471 */
28672, 45056, 42752, 35584, 39936, 38400, 23040, 20736, /* 1472-1479 */
35840, 41216, 28160, 15104, 21248, 34304, 33536, 35072, /* 1480-1487 */
39936, 31232, 27136, 37376, 45824, 40448, 18688, 16896, /* 1488-1495 */
38144, 38912, 26880, 32256, 44800, 40704, 26624, 28928, /* 1496-1503 */
38144, 32768, 28160, 34048, 41216, 34048, 22016, 35328, /* 1504-1511 */
49664, 35072, 25088, 32768, 36608, 27648, 19200, 29696, /* 1512-1519 */
39424, 28160, 15104, 23296, 37376, 36096, 35328, 45056, /* 1520-1527 */
43264, 29184, 29440, 40704, 41984, 29440, 19200, 27904, /* 1528-1535 */
38912, 29184, 21504, 33536, 39424, 23552, 16640, 33792, /* 1536-1543 */
47872, 42496, 30208, 31744, 37376, 28160, 25600, 38912, /* 1544-1551 */
38144, 23040, 23296, 38656, 44032, 29184, 19456, 36608, /* 1552-1559 */
48384, 37632, 25600, 30208, 41472, 33280, 27392, 40704, /* 1560-1567 */
39680, 25856, 25344, 34560, 38400, 27136, 15104, 24576, /* 1568-1575 */
38912, 34816, 30976, 39424, 42752, 31488, 20224, 28416, /* 1576-1583 */
45056, 42240, 27904, 26112, 35328, 38912, 36096, 38400, /* 1584-1591 */
40192, 27136, 16640, 27392, 41728, 35840, 22272, 24576, /* 1592-1599 */
41216, 47872, 33280, 27392, 37632, 35072, 23552, 24576, /* 1600-1607 */
34560, 37120, 29696, 29184, 37120, 37376, 25856, 23040, /* 1608-1615 */
36608, 46080, 42240, 37632, 40192, 40960, 25856, 18176, /* 1616-1623 */
33792, 42240, 31744, 22528, 23808, 27904, 28928, 30464, /* 1624-1631 */
37632, 38144, 30464, 29952, 39936, 46336, 37120, 22528, /* 1632-1639 */
22272, 32256, 34048, 28672, 30208, 38656, 37888, 28160, /* 1640-1647 */
25600, 32000, 38144, 34048, 30464, 38400, 40960, 30208, /* 1648-1655 */
27904, 34816, 37888, 37376, 32768, 31488, 37888, 33280, /* 1656-1663 */
20224, 24320, 37376, 37632, 25344, 20480, 30976, 38912, /* 1664-1671 */
33280, 29696, 37632, 41984, 36864, 36608, 42240, 42752, /* 1672-1679 */
32000, 20992, 25600, 37120, 35328, 29440, 32000, 34816, /* 1680-1687 */
30720, 23296, 22528, 29440, 37120, 38656, 35584, 39680, /* 1688-1695 */
41216, 35072, 32256, 33024, 30720, 27136, 26368, 30464, /* 1696-1703 */
36352, 35328, 25088, 23040, 34560, 38400, 32256, 30720, /* 1704-1711 */
37888, 45312, 38656, 30720, 34048, 33792, 29952, 32768, /* 1712-1719 */
36096, 35584, 32000, 23808, 17920, 25344, 33792, 30976, /* 1720-1727 */
29184, 34816, 41216, 38912, 29184, 27136, 36864, 40192, /* 1728-1735 */
31232, 24576, 29952, 37120, 34304, 32256, 36864, 36864, /* 1736-1743 */
30208, 26880, 34304, 40960, 35328, 25088, 25088, 32000, /* 1744-1751 */
35584, 33024, 31232, 36352, 43520, 37888, 25344, 27392, /* 1752-1759 */
32768, 30464, 28416, 31488, 36096, 35072, 28416, 23808, /* 1760-1767 */
27392, 34048, 33024, 31232, 36352, 42496, 42496, 34048, /* 1768-1775 */
28416, 33792, 37632, 31744, 24576, 28416, 34816, 34304, /* 1776-1783 */
30720, 28672, 29440, 28928, 26368, 27648, 35328, 43776, /* 1784-1791 */
40448, 30720, 30976, 35328, 36352, 32256, 27136, 30464, /* 1792-1799 */
36352, 33280, 25856, 25600, 30976, 33792, 30976, 30976, /* 1800-1807 */
35328, 37376, 35840, 35072, 40192, 41472, 33536, 28672, /* 1808-1815 */
30208, 32256, 35328, 33536, 27392, 27904, 33024, 30720, /* 1816-1823 */
23040, 23296, 31744, 34816, 30976, 30720, 35072, 36608, /* 1824-1831 */
33792, 31232, 34304, 39936, 38400, 28672, 25600, 31232, /* 1832-1839 */
35840, 33536, 30976, 32256, 38144, 37376, 28672, 25344, /* 1840-1847 */
29184, 33536, 33280, 28928, 27648, 31488, 36864, 37120, /* 1848-1855 */
35840, 41472, 42752, 31232, 24320, 26880, 33280, 35328, /* 1856-1863 */
29952, 24576, 27136, 34560, 33792, 27136, 25600, 32000, /* 1864-1871 */
37888, 36096, 32256, 35072, 41728, 41472, 35328, 33024, /* 1872-1879 */
36352, 35328, 28416, 26112, 31488, 35328, 33024, 27904, /* 1880-1887 */
25344, 29440, 33024, 29440, 25344, 28928, 39168, 43520, /* 1888-1895 */
37888, 31744, 30208, 33280, 34304, 30464, 30976, 35328, /* 1896-1903 */
34560, 28672, 26880, 32256, 38656, 36352, 26368, 21504, /* 1904-1911 */
29440, 39936, 39424, 34048, 37376, 41216, 37632, 29952, /* 1912-1919 */
24576, 26112, 33792, 38400, 35072, 29184, 29440, 33024, /* 1920-1927 */
29440, 24832, 28416, 35584, 35840, 29696, 28416, 33280, /* 1928-1935 */
37888, 36352, 28160, 26112, 34816, 41728, 38400, 29440, /* 1936-1943 */
27648, 33792, 38144, 33792, 28672, 31488, 36352, 34048, /* 1944-1951 */
29440, 31232, 36608, 38144, 30464, 21248, 22272, 32000, /* 1952-1959 */
39168, 38400, 35072, 38656, 43264, 38144, 26624, 20736, /* 1960-1967 */
24576, 33024, 34816, 30208, 27392, 30208, 35072, 33536, /* 1968-1975 */
29696, 30976, 35584, 36096, 31744, 30976, 38656, 46848, /* 1976-1983 */
44800, 31744, 22528, 27648, 35328, 32000, 26624, 29184, /* 1984-1991 */
35072, 36864, 31744, 24320, 22784, 27904, 30976, 30464, /* 1992-1999 */
31488, 36864, 42752, 40704, 33024, 29696, 33280, 36096, /* 2000-2007 */
34304, 29184, 29184, 34560, 37632, 33280, 27136, 26624, /* 2008-2015 */
33024, 36608, 31744, 26112, 27136, 34048, 39680, 37632, /* 2016-2023 */
35328, 38400, 39424, 33536, 26624, 27904, 34304, 40192, /* 2024-2031 */
37632, 28416, 21760, 24832, 32768, 32000, 26880, 27904, /* 2032-2039 */
34560, 38912, 36352, 28672, 26112, 29952, 35584, 34560, /* 2040-2047 */
30464, 31744, 37888, 40192, 38144, 34560, 35584, 39680, /* 2048-2055 */
36608, 28416, 25856, 30208, 37632, 38400, 31232, 25344, /* 2056-2063 */
28672, 36096, 36352, 28160, 22528, 27136, 36608, 38912, /* 2064-2071 */
36352, 33280, 35328, 39936, 35584, 29440, 29440, 33024, /* 2072-2079 */
35072, 31232, 22784, 22016, 30464, 36864, 34048, 29184, /* 2080-2087 */
28672, 32768, 35840, 33536, 28160, 28928, 37888, 44544, /* 2088-2095 */
40704, 32256, 27904, 29440, 33280, 33280, 30976, 33280, /* 2096-2103 */
38400, 36608, 29440, 25856, 26880, 33536, 35072, 28416, /* 2104-2111 */
22784, 26368, 37120, 42496, 37632, 32768, 34816, 39424, /* 2112-2119 */
38912, 33280, 26624, 26624, 30720, 34048, 33536, 31744, /* 2120-2127 */
33280, 36608, 35072, 29440, 25856, 29440, 36864, 39168, /* 2128-2135 */
34816, 32000, 35328, 40704, 39424, 30720, 24064, 26880, /* 2136-2143 */
36096, 37632, 31744, 27648, 28928, 32768, 33280, 29952, /* 2144-2151 */
26880, 28672, 33792, 33280, 30208, 30720, 35328, 40448, /* 2152-2159 */
38656, 28928, 21760, 23040, 32768, 38400, 35584, 34304, /* 2160-2167 */
36608, 39680, 40704, 34560, 25344, 23552, 30208, 34816, /* 2168-2175 */
33536, 30208, 29440, 33792, 38144, 35328, 30976, 32256, /* 2176-2183 */
35840, 35840, 32256, 28160, 30720, 40192, 43008, 37888, /* 2184-2191 */
30208, 25088, 29184, 34816, 30464, 24832, 25600, 31488, /* 2192-2199 */
38912, 37888, 30208, 26368, 28416, 32000, 32000, 28928, /* 2200-2207 */
30464, 37632, 43008, 41728, 35840, 30976, 34048, 38400, /* 2208-2215 */
36608, 30208, 26624, 29184, 35584, 37376, 32768, 27136, /* 2216-2223 */
27136, 33280, 34560, 29952, 24576, 22016, 27648, 36608, /* 2224-2231 */
38400, 36864, 37888, 39168, 38912, 35584, 30720, 29440, /* 2232-2239 */
33792, 37888, 34816, 26880, 22016, 26112, 34816, 36096, /* 2240-2247 */
31744, 27904, 28416, 34816, 37120, 33024, 28928, 29696, /* 2248-2255 */
36096, 40704, 37632, 33024, 30720, 32000, 34816, 33280, /* 2256-2263 */
30720, 31744, 35840, 38400, 33536, 26880, 24832, 29184, /* 2264-2271 */
34304, 32768, 27392, 24320, 28160, 38144, 40448, 34048, /* 2272-2279 */
29440, 28672, 33280, 36608, 34560, 30976, 30720, 34816, /* 2280-2287 */
37888, 35840, 34048, 35072, 37120, 36864, 32256, 25600, /* 2288-2295 */
21760, 28160, 35072, 35840, 34816, 33024, 33280, 38656, /* 2296-2303 */
36864, 29440, 26368, 27392, 33792, 38656, 37120, 31744, /* 2304-2311 */
30208, 33024, 35584, 34560, 31488, 29696, 30976, 33024, /* 2312-2319 */
31744, 30208, 29696, 34048, 39168, 37120, 29696, 23552, /* 2320-2327 */
22528, 29184, 35584, 36352, 34816, 35840, 41472, 43520, /* 2328-2335 */
39424, 32768, 27136, 26624, 31232, 33024, 31232, 29696, /* 2336-2343 */
31488, 34560, 35840, 34304, 29952, 27904, 32000, 32256, /* 2344-2351 */
29184, 29184, 29440, 34560, 41216, 39936, 33536, 30720, /* 2352-2359 */
31488, 35072, 36352, 30720, 24832, 25088, 30464, 35328, /* 2360-2367 */
35584, 32768, 29696, 29952, 32768, 32000, 29952, 29184, /* 2368-2375 */
32768, 37888, 38912, 35840, 32000, 30208, 34304, 37888, /* 2376-2383 */
36096, 32768, 30464, 31232, 35840, 35072, 31232, 29440, /* 2384-2391 */
28928, 32768, 35584, 33792, 28160, 24064, 26368, 31232, /* 2392-2399 */
34048, 35584, 36608, 37376, 38656, 37376, 32768, 29440, /* 2400-2407 */
29440, 34560, 38144, 35328, 30208, 27136, 28160, 34048, /* 2408-2415 */
36352, 34304, 30208, 28160, 30720, 33536, 32256, 29952, /* 2416-2423 */
27136, 29184, 35072, 38400, 37120, 34560, 32768, 33536, /* 2424-2431 */
34560, 33792, 31744, 30720, 34560, 38144, 36352, 34304, /* 2432-2439 */
31744, 29696, 33792, 34560, 29184, 26112, 25600, 28160, /* 2440-2447 */
35840, 37120, 33280, 29696, 28160, 30464, 34816, 33792, /* 2448-2455 */
30208, 29440, 31744, 36352, 38656, 38400, 36608, 37120, /* 2456-2463 */
39936, 38656, 32256, 26112, 22528, 25600, 30976, 33792, /* 2464-2471 */
34304, 32768, 32768, 36352, 36608, 31744, 29184, 25600, /* 2472-2479 */
26112, 32768, 36864, 34560, 32256, 33024, 34304, 37120, /* 2480-2487 */
38144, 35072, 33024, 33280, 32768, 30976, 29952, 28672, /* 2488-2495 */
29952, 35584, 38144, 34304, 28928, 25088, 25600, 29440, /* 2496-2503 */
32000, 30976, 31232, 33024, 37888, 42752, 40704, 35584, /* 2504-2511 */
31232, 29696, 30976, 33280, 32000, 29952, 29696, 33024, /* 2512-2519 */
35584, 34560, 32000, 30464, 30976, 33280, 32256, 29184, /* 2520-2527 */
27392, 26880, 31232, 37888, 37888, 35072, 33792, 33280, /* 2528-2535 */
35072, 36608, 33792, 28928, 27136, 28672, 32768, 36096, /* 2536-2543 */
34816, 33024, 32256, 32000, 33280, 33280, 30720, 29696, /* 2544-2551 */
31232, 34816, 34816, 32256, 30720, 30208, 33536, 37376, /* 2552-2559 */
37376, 34816, 32768, 30976, 33536, 36096, 33280, 29952, /* 2560-2567 */
30464, 31488, 34816, 36608, 33536, 29696, 27136, 27392, /* 2568-2575 */
29184, 30976, 32000, 33536, 35328, 36864, 36864, 34304, /* 2576-2583 */
31744, 30208, 31232, 34816, 34816, 32000, 30208, 29184, /* 2584-2591 */
31232, 35840, 38144, 36096, 34560, 33536, 32768, 34048, /* 2592-2599 */
33536, 28928, 27392, 27904, 30464, 33792, 34816, 34304, /* 2600-2607 */
33536, 33280, 34560, 33536, 31232, 30720, 31488, 34304, /* 2608-2615 */
36608, 36352, 34304, 32768, 31744, 34560, 36352, 32768, /* 2616-2623 */
28416, 27136, 27904, 30720, 33792, 33536, 30720, 29184, /* 2624-2631 */
29952, 33024, 34048, 31488, 29952, 29952, 29952, 32768, /* 2632-2639 */
34816, 35072, 34816, 37120, 39680, 39936, 36096, 33536, /* 2640-2647 */
29184, 26880, 29440, 31744, 31744, 31744, 32000, 32000, /* 2648-2655 */
34304, 36608, 32768, 30208, 29440, 28416, 31488, 33280, /* 2656-2663 */
31488, 32000, 31488, 31232, 35328, 37632, 35840, 35072, /* 2664-2671 */
35072, 34304, 34048, 32768, 30208, 29952, 31488, 33792, /* 2672-2679 */
36864, 35328, 31232, 28928, 27648, 28672, 30976, 31488, /* 2680-2687 */
30720, 30976, 32768, 36096, 39168, 37376, 34816, 33792, /* 2688-2695 */
31488, 31744, 33280, 32256, 30720, 29696, 29440, 32256, /* 2696-2703 */
34048, 33280, 33024, 33536, 33536, 34816, 34048, 30208, /* 2704-2711 */
28160, 27392, 28928, 34304, 36096, 34048, 33024, 32256, /* 2712-2719 */
33280, 35840, 35584, 33024, 30208, 28928, 30720, 34560, /* 2720-2727 */
36352, 34816, 33280, 33536, 33280, 33792, 34048, 32000, /* 2728-2735 */
30464, 30208, 32000, 34048, 32256, 31488, 31744, 32000, /* 2736-2743 */
34816, 37632, 36864, 34816, 33792, 30976, 30720, 34304, /* 2744-2751 */
33024, 29440, 31488, 32000, 31744, 35584, 35584, 33024, /* 2752-2759 */
29440, 27392, 27904, 29440, 31232, 30976, 32000, 33024, /* 2760-2767 */
33280, 35072, 36096, 33792, 32768, 32256, 33536, 34304, /* 2768-2775 */
33280, 30976, 30208, 28672, 30208, 35072, 37632, 36864, /* 2776-2783 */
36096, 35072, 34048, 35072, 33792, 29440, 28160, 27392, /* 2784-2791 */
28160, 32000, 34816, 35072, 34304, 33024, 31744, 32768, /* 2792-2799 */
33792, 32256, 30976, 32768, 34560, 35584, 35840, 35072, /* 2800-2807 */
34560, 32256, 31744, 35584, 35072, 30976, 28416, 27648, /* 2808-2815 */
27648, 30208, 32000, 33280, 32768, 32000, 32768, 34816, /* 2816-2823 */
35584, 33792, 30208, 29184, 28672, 29696, 33024, 34816, /* 2824-2831 */
35328, 35840, 35584, 37376, 38144, 35328, 33024, 31744, /* 2832-2839 */
30208, 30720, 33024, 32256, 30720, 31232, 31232, 31232, /* 2840-2847 */
35328, 35584, 30720, 29184, 30208, 29440, 30720, 33024, /* 2848-2855 */
33024, 31232, 30464, 32256, 35840, 37376, 36352, 34048, /* 2856-2863 */
33280, 31232, 30720, 32000, 32768, 32000, 32768, 33792, /* 2864-2871 */
36096, 36608, 33536, 32000, 30208, 26624, 28160, 30976, /* 2872-2879 */
30976, 30976, 33280, 34304, 34816, 38912, 39936, 34816, /* 2880-2887 */
33536, 33536, 30464, 31744, 34304, 32256, 29952, 28928, /* 2888-2895 */
29952, 31232, 33024, 33792, 33024, 33024, 33280, 33024, /* 2896-2903 */
32256, 30976, 29440, 28928, 30464, 33280, 36608, 36608, /* 2904-2911 */
34304, 32768, 31232, 30720, 30464, 31488, 32000, 31488, /* 2912-2919 */
33024, 33792, 34816, 37888, 36352, 33024, 32256, 31232, /* 2920-2927 */
30464, 31232, 31488, 30720, 29440, 28928, 30464, 32256, /* 2928-2935 */
34560, 36352, 36864, 37376, 37632, 37888, 35840, 32768, /* 2936-2943 */
31232, 29696, 29184, 31232, 35072, 35072, 32768, 32768, /* 2944-2951 */
32000, 30720, 31488, 31744, 31232, 29952, 29440, 28928, /* 2952-2959 */
30464, 33792, 33792, 32768, 33280, 33792, 32256, 31744, /* 2960-2967 */
33536, 33024, 31232, 30464, 31488, 33792, 34560, 34304, /* 2968-2975 */
35072, 34816, 34816, 36096, 35584, 33280, 32000, 31232, /* 2976-2983 */
29696, 29696, 32000, 32256, 29952, 30464, 33024, 33024, /* 2984-2991 */
34304, 36352, 35328, 33024, 30720, 29440, 29184, 31488, /* 2992-2999 */
33280, 33280, 34048, 35328, 35328, 34816, 35072, 34304, /* 3000-3007 */
32000, 31232, 31744, 33024, 33024, 30720, 30720, 31232, /* 3008-3015 */
29440, 30208, 33024, 34048, 32768, 32768, 33536, 32256, /* 3016-3023 */
32768, 34304, 32000, 30720, 33536, 34048, 33536, 36608, /* 3024-3031 */
37376, 35584, 33280, 30976, 29696, 29440, 29952, 30976, /* 3032-3039 */
32000, 33024, 33280, 34048, 34048, 33792, 33792, 33024, /* 3040-3047 */
32256, 32768, 34304, 34560, 31744, 30464, 30464, 30208, /* 3048-3055 */
30464, 32256, 35072, 35328, 34304, 33792, 33024, 33536, /* 3056-3063 */
34816, 32768, 30208, 30720, 30720, 30976, 32768, 33280, /* 3064-3071 */
33536, 32256, 30976, 30720, 31232, 31744, 32000, 31488, /* 3072-3079 */
32256, 34304, 35584, 36864, 36864, 35584, 35328, 34816, /* 3080-3087 */
32256, 32768, 34304, 32000, 29696, 29952, 29952, 30208, /* 3088-3095 */
31744, 32000, 31744, 32000, 31232, 31488, 32000, 32768, /* 3096-3103 */
32768, 30976, 29440, 30208, 31232, 31488, 33280, 34816, /* 3104-3111 */
35584, 34816, 34048, 34304, 34304, 33024, 31744, 32768, /* 3112-3119 */
31744, 31232, 33536, 35328, 34304, 33024, 33792, 33280, /* 3120-3127 */
31232, 33024, 34304, 31488, 28928, 29440, 30208, 30720, /* 3128-3135 */
32768, 34816, 35584, 34048, 33536, 33536, 33280, 33536, /* 3136-3143 */
33024, 31488, 31232, 31744, 32768, 33536, 34560, 34048, /* 3144-3151 */
33536, 32768, 33024, 34048, 35072, 32000, 29952, 30208, /* 3152-3159 */
28928, 28160, 30464, 32256, 33024, 34048, 35072, 35584, /* 3160-3167 */
34816, 35840, 36096, 32256, 29696, 30720, 30976, 30976, /* 3168-3175 */
33792, 34816, 34560, 34048, 32256, 31488, 31232, 31744, /* 3176-3183 */
31744, 32000, 31488, 31488, 32000, 32256, 33280, 34048, /* 3184-3191 */
33280, 33792, 35328, 35584, 36352, 35328, 32768, 29696, /* 3192-3199 */
27904, 28416, 29184, 30208, 32768, 34048, 34048, 34560, /* 3200-3207 */
34048, 33792, 34560, 33280, 29696, 29184, 29952, 29440, /* 3208-3215 */
30464, 32256, 33024, 32256, 32000, 32000, 32000, 32256, /* 3216-3223 */
33792, 34048, 33536, 33024, 33536, 34304, 34816, 34816, /* 3224-3231 */
34048, 34816, 35584, 35072, 34816, 36096, 34816, 31488, /* 3232-3239 */
29952, 29440, 28672, 28416, 29184, 30720, 32000, 32768, /* 3240-3247 */
33536, 34304, 34816, 36096, 35584, 33280, 31232, 30464, /* 3248-3255 */
29952, 30976, 32000, 33536, 33024, 33536, 34048, 33024, /* 3256-3263 */
33280, 34048, 33024, 32768, 33024, 32256, 31744, 33024, /* 3264-3271 */
33280, 31232, 31744, 33024, 32000, 31488, 34048, 34304, /* 3272-3279 */
31744, 30208, 30720, 30976, 30464, 31232, 33280, 34304, /* 3280-3287 */
34816, 34560, 33792, 34304, 34304, 33536, 32768, 32000, /* 3288-3295 */
31744, 31488, 31488, 30720, 31232, 31744, 31488, 31744, /* 3296-3303 */
32256, 33792, 34816, 34048, 33536, 34048, 32256, 30464, /* 3304-3311 */
30464, 32768, 33280, 33024, 34304, 35584, 34816, 34048, /* 3312-3319 */
35072, 34304, 30976, 30720, 32256, 31232, 31488, 33024, /* 3320-3327 */
33280, 32768, 31488, 30720, 31232, 31488, 31744, 33280, /* 3328-3335 */
32768, 31744, 32768, 33024, 32000, 32256, 34048, 34304, /* 3336-3343 */
34560, 35584, 36096, 36352, 36096, 33536, 32000, 32000, /* 3344-3351 */
29952, 29184, 29440, 30464, 31488, 31488, 32256, 34048, /* 3352-3359 */
33536, 32768, 34304, 33536, 30720, 30208, 31488, 30464, /* 3360-3367 */
29952, 31744, 33536, 34048, 33536, 33280, 33024, 33280, /* 3368-3375 */
33024, 33024, 33536, 33280, 33280, 34048, 33792, 34048, /* 3376-3383 */
34560, 34304, 33024, 32768, 32768, 33280, 34048, 33024, /* 3384-3391 */
31232, 30208, 28672, 28672, 29696, 30208, 31488, 34048, /* 3392-3399 */
34816, 35328, 36608, 36352, 35840, 35840, 32768, 30208, /* 3400-3407 */
30720, 30976, 30720, 32000, 33024, 33280, 33024, 31744, /* 3408-3415 */
30464, 30976, 31488, 31488, 33024, 33024, 32768, 33536, /* 3416-3423 */
33792, 34048, 33792, 33536, 33280, 34304, 34304, 33792, /* 3424-3431 */
34560, 35584, 34048, 30976, 29952, 29696, 30208, 31488, /* 3432-3439 */
31232, 32768, 34048, 33792, 33536, 33536, 33792, 33280, /* 3440-3447 */
33536, 32256, 29952, 29184, 29952, 30208, 30720, 32256, /* 3448-3455 */
33536, 34304, 35072, 34816, 34048, 33792, 33792, 32768, /* 3456-3463 */
31744, 32000, 33024, 33792, 33792, 34560, 34304, 32768, /* 3464-3471 */
32256, 32256, 31232, 30976, 32256, 32768, 30976, 29440, /* 3472-3479 */
29440, 30464, 30464, 31488, 32256, 33280, 34304, 34048, /* 3480-3487 */
34048, 34048, 33536, 33280, 33536, 32768, 31232, 31744, /* 3488-3495 */
33024, 33536, 33280, 34304, 34816, 34304, 33280, 33024, /* 3496-3503 */
32256, 32256, 32256, 31232, 31232, 30976, 30976, 31744, /* 3504-3511 */
33024, 33792, 34560, 34816, 35584, 35328, 34048, 32768, /* 3512-3519 */
32768, 32000, 30464, 29952, 30720, 32000, 32000, 32768, /* 3520-3527 */
33536, 33280, 33024, 32000, 30976, 30976, 30464, 30976, /* 3528-3535 */
32000, 31488, 31488, 31744, 33024, 33280, 32768, 33024, /* 3536-3543 */
33536, 34048, 33280, 33024, 33280, 34048, 33536, 32256, /* 3544-3551 */
32256, 33280, 33280, 32768, 33536, 34560, 34560, 33792, /* 3552-3559 */
33792, 33280, 32768, 31744, 31488, 32256, 30720, 28672, /* 3560-3567 */
29952, 31232, 32000, 33024, 34048, 34560, 34560, 33536, /* 3568-3575 */
32256, 31488, 30976, 29952, 31232, 32256, 32768, 33792, /* 3576-3583 */
35840, 35840, 35328, 34560, 34304, 33024, 32000, 31744, /* 3584-3591 */
31744, 32256, 32768, 32768, 31744, 31232, 31744, 31488, /* 3592-3599 */
31488, 30976, 31232, 32768, 33024, 33280, 33280, 33024, /* 3600-3607 */
32000, 33024, 33792, 33280, 33024, 34048, 34816, 34048, /* 3608-3615 */
33792, 33280, 32768, 32256, 31232, 30208, 29952, 29696, /* 3616-3623 */
30208, 30720, 32000, 33024, 33280, 33792, 34560, 35072, /* 3624-3631 */
34816, 34560, 33536, 32000, 31232, 31232, 31488, 33024, /* 3632-3639 */
33792, 33280, 33024, 33280, 32768, 31744, 30720, 30464, /* 3640-3647 */
30720, 31744, 32000, 32768, 33280, 33536, 34048, 34304, /* 3648-3655 */
33280, 32256, 32256, 32768, 31744, 31744, 32000, 31744, /* 3656-3663 */
32000, 32000, 31232, 30976, 31488, 32000, 33024, 34816, /* 3664-3671 */
35840, 36096, 35840, 35840, 35072, 34304, 33280, 32768, /* 3672-3679 */
31744, 30976, 30976, 31488, 31744, 32768, 32768, 32256, /* 3680-3687 */
31744, 30976, 31232, 31744, 30976, 30464, 31232, 31488, /* 3688-3695 */
31744, 32768, 33792, 34304, 34560, 35328, 35328, 34304, /* 3696-3703 */
33024, 32768, 32000, 31232, 31232, 31232, 31488, 31488, /* 3704-3711 */
32256, 32000, 31488, 32000, 32256, 33024, 33536, 33792, /* 3712-3719 */
33536, 33792, 33536, 33280, 32768, 31744, 31232, 32256, /* 3720-3727 */
33536, 33536, 34048, 35072, 35584, 34560, 33024, 31744, /* 3728-3735 */
30976, 30464, 30464, 30208, 30464, 31488, 32768, 33280, /* 3736-3743 */
33536, 33536, 33536, 33280, 33536, 33280, 32000, 32000, /* 3744-3751 */
31744, 31232, 30976, 31232, 31744, 32768, 33280, 33536, /* 3752-3759 */
34048, 33536, 34048, 33792, 33792, 33280, 33024, 33024, /* 3760-3767 */
33280, 33792, 33536, 33792, 33536, 33536, 33280, 33024, /* 3768-3775 */
32256, 32000, 31744, 32000, 31232, 30464, 30208, 30464, /* 3776-3783 */
30464, 30720, 31232, 31744, 33792, 34816, 35072, 35072, /* 3784-3791 */
34560, 33536, 32768, 32256, 32256, 32000, 31488, 32000, /* 3792-3799 */
32768, 32768, 32768, 32768, 32768, 32256, 32256, 31744, /* 3800-3807 */
31488, 31232, 32256, 32768, 32256, 32768, 32768, 33024, /* 3808-3815 */
33024, 33792, 34560, 34816, 34304, 34304, 34560, 34048, /* 3816-3823 */
32768, 31744, 32256, 32256, 31232, 31232, 31744, 32768, /* 3824-3831 */
33280, 33024, 33024, 33024, 33024, 32768, 32000, 31488, /* 3832-3839 */
31232, 30720, 30976, 31488, 31744, 32000, 32768, 33536, /* 3840-3847 */
35328, 35328, 34816, 34304, 34048, 33280, 31744, 30976, /* 3848-3855 */
31232, 31488, 32256, 32256, 32768, 34048, 33536, 33024, /* 3856-3863 */
32768, 32768, 32768, 32256, 31232, 31744, 32000, 31744, /* 3864-3871 */
31744, 32000, 33024, 32768, 32256, 32256, 33280, 33792, /* 3872-3879 */
33792, 33280, 33024, 33024, 32256, 31488, 30976, 31232, /* 3880-3887 */
31232, 31232, 32256, 33536, 34304, 34304, 34304, 34048, /* 3888-3895 */
33792, 33280, 32256, 31488, 31488, 31232, 31488, 30720, /* 3896-3903 */
31488, 33536, 34048, 34048, 34560, 34816, 34816, 34048, /* 3904-3911 */
32768, 31744, 31488, 30976, 31488, 31744, 32256, 33280, /* 3912-3919 */
33280, 34048, 34048, 33280, 32768, 31232, 31744, 32000, /* 3920-3927 */
31744, 31232, 31232, 30976, 32000, 32256, 32000, 31744, /* 3928-3935 */
32000, 32256, 33024, 33280, 33792, 33536, 34304, 33536, /* 3936-3943 */
33792, 33024, 32256, 32256, 33024, 33280, 33024, 33280, /* 3944-3951 */
34304, 34048, 33792, 33792, 32768, 32256, 31744, 30720, /* 3952-3959 */
30976, 30720, 30208, 30464, 31744, 32256, 33024, 34048, /* 3960-3967 */
34816, 35072, 34816, 34304, 33536, 32256, 30976, 31232, /* 3968-3975 */
31232, 30976, 31744, 32256, 33024, 33536, 33536, 32768, /* 3976-3983 */
31744, 31744, 31488, 31232, 31232, 32000, 32256, 33024, /* 3984-3991 */
33024, 33280, 33792, 33280, 33280, 33536, 33280, 33024, /* 3992-3999 */
33024, 33024, 33536, 33024, 33024, 32256, 31488, 32000, /* 4000-4007 */
31744, 32000, 32768, 32768, 33280, 33792, 34048, 33280, /* 4008-4015 */
33024, 33792, 33024, 32768, 32768, 32256, 31488, 30976, /* 4016-4023 */
31488, 32000, 32000, 33280, 33280, 33536, 34048, 33280, /* 4024-4031 */
33280, 32256, 31744, 30976, 30976, 31232, 31488, 32768, /* 4032-4039 */
33792, 34048, 34304, 34560, 34304, 33536, 33792, 32768, /* 4040-4047 */
31488, 31488, 31488, 32000, 32768, 32000, 32000, 32768, /* 4048-4055 */
32768, 32256, 32256, 32256, 32000, 31744, 31744, 32000, /* 4056-4063 */
32768, 32768, 32768, 33024, 33536, 34048, 34304, 34048, /* 4064-4071 */
34304, 33536, 33536, 33024, 32768, 32256, 31744, 31744, /* 4072-4079 */
31232, 31488, 31488, 31744, 31232, 31232, 31232, 31744, /* 4080-4087 */
31744, 33536, 34048, 34816, 34560, 34560, 34304, 33280, /* 4088-4095 */
33024, 32256, 32256, 32000, 32768, 32768, 33280, 33280, /* 4096-4103 */
33536, 32768, 33024, 32256, 31488, 30976, 31232, 31232, /* 4104-4111 */
31488, 31488, 31744, 32768, 32768, 32768, 33536, 34048, /* 4112-4119 */
33792, 33792, 33280, 33024, 32256, 32000, 31744, 32000, /* 4120-4127 */
32000, 32000, 32768, 33024, 33280, 33536, 33792, 33280, /* 4128-4135 */
32256, 32000, 31488, 32000, 31744, 32768, 33024, 33024, /* 4136-4143 */
33024, 33280, 33536, 33280, 33280, 32768, 33024, 33024, /* 4144-4151 */
32768, 33536, 33024, 32768, 32768, 32000, 31744, 31744, /* 4152-4159 */
31488, 31744, 32000, 32768, 32256, 32000, 33280, 33024, /* 4160-4167 */
33024, 33024, 33024, 33280, 33536, 32768, 33280, 32768, /* 4168-4175 */
32768, 32000, 32256, 32000, 32768, 32256, 32768, 32256, /* 4176-4183 */
32256, 32768, 32256, 32000, 31488, 32000, 31488, 32000, /* 4184-4191 */
33024, 34048, 34560, 34816, 34816, 34560, 34048, 33792, /* 4192-4199 */
32768, 32768, 32000, 31488, 32000, 31744, 32000, 32000, /* 4200-4207 */
32000, 31744, 32768, 32000, 32256, 32256, 32256, 32000, /* 4208-4215 */
32000, 31744, 31744, 32256, 32000, 32256, 32768, 33280, /* 4216-4223 */
33792, 33792, 34048, 33536, 33024, 33024, 32768, 32256, /* 4224-4231 */
32000, 32000, 31744, 32000, 32768, 32256, 32256, 32256, /* 4232-4239 */
31744, 32000, 32000, 32000, 31744, 32256, 33280, 33280, /* 4240-4247 */
33280, 33280, 33280, 33536, 33024, 33280, 33280, 33280, /* 4248-4255 */
33280, 33280, 33792, 33280, 33024, 32768, 32256, 32256, /* 4256-4263 */
31744, 32000, 31488, 31232, 31744, 31232, 31232, 31744, /* 4264-4271 */
32256, 33024, 33024, 33024, 34048, 33792, 34048, 33280, /* 4272-4279 */
33536, 32768, 32000, 32000, 32000, 32256, 32768, 32768, /* 4280-4287 */
33280, 33280, 33536, 33024, 32768, 32256, 31488, 31744, /* 4288-4295 */
31744, 31744, 32256, 32768, 33024, 33280, 33536, 33280, /* 4296-4303 */
33536, 33792, 33536, 33024, 33536, 32768, 32000, 32256, /* 4304-4311 */
32256, 32256, 32000, 32256, 32000, 32768, 33280, 33024, /* 4312-4319 */
33024, 32768, 32768, 32768, 32000, 31488, 32256, 32768, /* 4320-4327 */
32000, 32256, 33024, 33024, 33024, 32768, 32768, 32768, /* 4328-4335 */
32256, 32256, 32768, 32768, 33024, 33024, 32768, 32768, /* 4336-4343 */
32768, 32000, 32256, 31744, 32000, 32000, 32768, 32768, /* 4344-4351 */
32768, 33024, 33280, 33280, 33536, 33024, 33024, 33024, /* 4352-4359 */
33024, 33024, 32768, 33280, 32768, 32000, 32768, 32768, /* 4360-4367 */
32256, 32768, 32768, 32768, 33024, 32768, 32256, 32256, /* 4368-4375 */
32000, 32000, 31744, 32000, 32000, 33024, 33536, 33792, /* 4376-4383 */
33792, 34048, 33536, 33792, 33024, 32768, 32768, 32000, /* 4384-4391 */
31232, 32000, 31744, 32000, 32000, 32000, 31744, 32256, /* 4392-4399 */
32256, 33024, 33024, 32768, 32768, 33024, 32256, 32256, /* 4400-4407 */
32256, 32000, 32256, 33024, 33024, 33280, 33280, 34048, /* 4408-4415 */
33536, 33792, 33280, 33024, 32768, 32256, 32256, 32000, /* 4416-4423 */
32256, 32768, 32768, 33024, 32768, 32768, 32256, 32768, /* 4424-4431 */
32000, 32768, 32256, 32256, 32768, 32768, 33024, 32768, /* 4432-4439 */
32768, 32768, 32768, 32256, 32768, 33024, 33536, 33024, /* 4440-4447 */
33024, 33280, 33024, 32768, 32256, 32256, 32256, 32000, /* 4448-4455 */
32000, 32256, 32000, 32000, 32256, 31744, 32000, 32256, /* 4456-4463 */
32768, 32768, 33024, 33536, 33536, 33280, 33280, 33536, /* 4464-4471 */
33024, 32768, 31744, 32256, 32768, 32256, 32256, 33024, /* 4472-4479 */
33024, 33024, 33280, 33024, 32768, 32768, 32768, 32768, /* 4480-4487 */
32256, 32000, 32256, 32256, 32000, 32768, 32256, 32768, /* 4488-4495 */
32768, 33024, 32768, 33024, 32768, 33024, 33024, 32256, /* 4496-4503 */
32256, 32000, 31744, 32256, 32000, 32256, 32256, 33024, /* 4504-4511 */
33024, 33536, 33536, 33280, 33024, 33024, 32256, 32768, /* 4512-4519 */
32000, 32256, 31744, 32768, 32256, 32256, 32768, 32768, /* 4520-4527 */
32768, 32768, 33024, 33024, 33536, 33024, 33024, 32768, /* 4528-4535 */
32768, 32256, 32256, 32768, 32768, 32256, 33024, 33280, /* 4536-4543 */
33280, 33536, 33280, 32768, 32768, 32768, 32256, 32256, /* 4544-4551 */
31744, 32256, 32256, 32256, 32256, 32768, 32256, 32768, /* 4552-4559 */
32000, 32256, 32256, 32256, 32768, 32256, 32768, 32256, /* 4560-4567 */
33024, 32768, 33024, 32768, 32768, 32768, 32768, 32768, /* 4568-4575 */
33024, 33024, 33536, 33280, 33280, 33024, 33024, 33280, /* 4576-4583 */
33024, 32256, 32000, 32256, 32000, 32256, 32000, 31744, /* 4584-4591 */
32256, 32256, 32256, 33024, 33280, 33536, 33280, 33536, /* 4592-4599 */
33536, 33024, 33024, 32768, 32768, 32256, 32256, 32000, /* 4600-4607 */
32256, 32768, 33024, 33280, 32768, 32768, 32768, 32768, /* 4608-4615 */
32000, 32256, 32000, 32256, 32000, 31744, 32256, 32000, /* 4616-4623 */
32256, 32256, 32768, 33024, 32768, 33024, 33280, 33024, /* 4624-4631 */
33024, 33280, 32768, 32768, 32768, 32768, 32000, 32768, /* 4632-4639 */
32256, 32768, 32768, 33024, 33280, 33280, 33024, 32768, /* 4640-4647 */
32768, 32768, 32256, 32000, 32000, 32256, 32768, 32256, /* 4648-4655 */
32768, 33024, 32768, 33024, 33280, 33024, 33280, 33280, /* 4656-4663 */
33024, 32768, 33280, 32768, 32000, 32256, 32256, 32256, /* 4664-4671 */
32256, 32256, 32768, 32768, 32768, 32768, 32768, 32256, /* 4672-4679 */
32000, 32768, 32000, 32768, 32256, 32768, 32768, 33024, /* 4680-4687 */
32768, 33024, 32768, 32768, 33024, 32768, 32768, 33280, /* 4688-4695 */
32768, 33024, 32768, 32768, 32768, 32768, 32768, 32256, /* 4696-4703 */
32000, 32768, 32256, 32256, 32768, 32768, 32768, 33024, /* 4704-4711 */
33024, 33280, 32768, 33024, 33024, 32768, 32768, 32768, /* 4712-4719 */
32768, 32768, 32256, 32768, 32256, 32000, 32768, 32768, /* 4720-4727 */
33280, 32768, 33024, 33024, 33024, 32768, 32256, 32256, /* 4728-4735 */
32256, 31744, 32256, 32768, 32256, 32768, 32768, 33024, /* 4736-4743 */
32768, 32768, 33024, 32768, 33024, 32768, 32256, 32768, /* 4744-4751 */
32768, 32768, 32256, 32768, 32768, 32768, 32768, 32768, /* 4752-4759 */
32768, 32768, 32768, 33024, 33024, 32768, 32768, 32768, /* 4760-4767 */
32768, 32256, 32256, 32768, 32768, 32768, 33024, 33024, /* 4768-4775 */
33280, 32768, 33280, 32768, 32768, 32768, 32768, 32768, /* 4776-4783 */
32768, 32256, 32768, 32256, 32768, 32768, 32768, 32768, /* 4784-4791 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4792-4799 */
32768, 32768, 32768, 32000, 32768, 33280, 32768, 32768, /* 4800-4807 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32000, /* 4808-4815 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32256, /* 4816-4823 */
32768, 32768, 32768, 32768, 32768, 32768, 33024, 32768, /* 4824-4831 */
32768, 32768, 33280, 32768, 32768, 32768, 32768, 32768, /* 4832-4839 */
32768, 32768, 33024, 32768, 32256, 32768, 32768, 32768, /* 4840-4847 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32000, /* 4848-4855 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 33280, /* 4856-4863 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4864-4871 */
32768, 32000, 32768, 32768, 32768, 32768, 32768, 32768, /* 4872-4879 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4880-4887 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4888-4895 */
32768, 33280, 32768, 32768, 32768, 32768, 32768, 32768, /* 4896-4903 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4904-4911 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4912-4919 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4920-4927 */
32768, 32768, 32768, 32768, 32768, 32768, 32768, 32768, /* 4928-4935 */
32768}; /* 4936-4936 */
