
#include "mbed.h"
#include "VS1002.h"
#include "TextLCD.h"
#include "RPG.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "SDFileSystem.h"
#include "fetch.h"

#include <string>
#include <iostream>
#include <sstream>

HTTPClient http1;
HTTPResult result1;
EthernetNetIf eth;
RPG rpg1(p26,p27,p25);
TextLCD lcd1(p10,p18,p24,p23,p22,p21,TextLCD::LCD16x2);
VS1002 mp3(p11,p12,p13,p8,"sd", p5,p6,p7,p14,p15,p16,p17,p20);
SDFileSystem sd(p11, p12, p13, p8, "sd");
char *ct[10]= {"/sd/0.txt","/sd/1.txt","/sd/2.txt","/sd/3.txt","/sd/4.txt","/sd/5.txt","/sd/6.txt","/sd/7.txt","/sd/8.txt","/sd/9.txt"};
char *mp3ct[10]= {"/sd/0.mp3","/sd/1.mp3","/sd/2.mp3","/sd/3.mp3","/sd/4.mp3","/sd/5.mp3","/sd/6.mp3","/sd/7.mp3","/sd/8.mp3","/sd/9.mp3"};

void download(string voiceurl, int a)
{
    HTTPFile f(mp3ct[a]);
    HTTPResult r = http1.get(voiceurl.c_str(), &f);
    if(r==HTTP_OK) {
        printf("download Result OK\n");
    } else {
        printf("download Error %d\n", r);
    }
    wait(1.5);
    HTTPFile clear(f);
    voiceurl.erase();

}

int main ()
{
    /*============================================================
     * MP3 Initialising
     *==========================================================*/
#ifndef FS_ONLY
    mp3._RST = 1;
    mp3.cs_high();                                   //chip disabled
    mp3.sci_initialise();                            //initialise MBED
    mp3.sci_write(0x00,(SM_SDINEW+SM_STREAM+SM_DIFF));
    mp3.sci_write(0x03, 0x9800);
    mp3.sdi_initialise();
#endif

    // make debug port Fast
    Serial pc(USBTX, USBRX);
    pc.baud(9600);

    lcd1.cls();
    lcd1.printf("net setup");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd1.printf("\n\r net error");

    }
    lcd1.printf("\n\r net ok");
    wait(0.5);
    lcd1.printf("streaming news");
    fetch();
    wait(1);
    lcd1.cls();
    int a=1;
    printf("%i\n",a);
    int count = 0;
    int oldcount=0;
    int dirt = 0;

    FILE * pFile;
    long lSize;
    char * buffer;
    size_t  result;

    while (true) {
        lcd1.printf(" news %d \n\n",a);
        dirt = rpg1.dir(); //Get Dir
        count = count + dirt; //Ad Dir to count
        if (count>oldcount) {
            oldcount=count;
            a++;
            lcd1.printf(" news %d \n\n",a);

        } else if(count<oldcount) {
            oldcount=count;
            a--;
            lcd1.printf(" news %d \n\n",a);
        }

        if (rpg1.pb()) {


            lcd1.printf("You have chosen the news %d \n",a);


            pFile = fopen ( ct[a], "rb" );
            if (pFile==NULL) {
                printf ("File error");
                exit (1);
            }

            // obtain file size:
            fseek (pFile , 0 , SEEK_END);
            lSize = ftell (pFile);
            rewind (pFile);

            // allocate memory to contain the whole file:
            buffer = (char*) malloc (sizeof(char)*lSize);
            if (buffer == NULL) {
                printf ("Memory error");
                exit (2);
            }

            // copy the file into the buffer:
            result = fread (buffer,1,lSize,pFile);
            if (result != lSize) {
                printf ("Reading error");
                exit (3);
            }
            string voiceurl=string(buffer);

            /* the whole file is now loaded in the memory buffer. */

            // terminate
            fclose (pFile);
            free (buffer);
            lcd1.printf("You have chosen the news %d \n",a);
            printf("%s\n",voiceurl.c_str());
            download( voiceurl,a);
            voiceurl.erase();
            wait(1);
            lcd1.cls();
            mp3.play_song(a+10);

            wait(1);

        }
        wait(0.2);
        printf("pb: %i  ", rpg1.pb()); //Print out Count

        printf("count:%d  dirt:%d\n",count,dirt);
    }
    printf("Done.\r\n");
}

