#include "mbed.h"
#include "VS1002.h"
#include "TextLCD.h"
#include "RPG.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "SDFileSystem.h"

#include <string>
#include <iostream>

TextLCD lcd2(p10, p18, p24, p23, p22, p21, TextLCD::LCD16x2 ); // rs, e, d0-d3

HTTPClient http;
HTTPResult result;
bool completed = false;

void request_callback(HTTPResult r)
{
    result = r;
    completed = true;
}



void  fetch ()
{
    string voiceurl;
    string httpurl = "http://translate.google.com/translate_tts?ie=UTF-8&tl=en&q=";
    Serial pc(USBTX, USBRX);
    pc.baud(9600);
    char* title[10];
    int counter=0;
    char *ct[10]= {"/sd/0.txt","/sd/1.txt","/sd/2.txt","/sd/3.txt","/sd/4.txt","/sd/5.txt","/sd/6.txt","/sd/7.txt","/sd/8.txt","/sd/9.txt"};
    char *tstartXML = "<title>"; //RSS XML start title
    char *tendXML ="</title>"; //RSS XML end title
    char *tsptr;
    char *teptr;
    int i=0,j=0;
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
   
    HTTPStream stream;
    char BigBuf[1024 + 1] = {0};
    stream.readNext((byte*)BigBuf, 1024); //Point to buffer for the first read
    //CNN Tech News RSS Feed - get web page with XML
    HTTPResult r = http.get("HTTP://rss.cnn.com/rss/cnn_tech.rss", &stream, request_callback);
//fetch new and print
    while (!completed) {
        Net::poll(); // Polls the Networking stack
        if (stream.readable()) { // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                teptr = strstr(tsptr,tendXML); // find <\title> in string - NULL if not

                if (tsptr!=NULL) {
                    tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"

                    voiceurl.erase();
                    voiceurl=tsptr;
                    voiceurl.erase(voiceurl.begin()+(strlen(tsptr)-strlen(teptr)),voiceurl.end());

                    printf("title: _____ %s\n",voiceurl);
                }
                if ((tsptr!=NULL)&&(teptr!=NULL)) {

                    voiceurl=httpurl+voiceurl;
                    for(i=0; (i<voiceurl.length()); i++) {
                        if(voiceurl[i]==' '||voiceurl[i]=='\'') {
                            voiceurl[i]='+';
                        }
                    }
                    voiceurl=voiceurl+"!!";
                    printf("%s\n",voiceurl.c_str());
                    if(counter==10) {
                        counter=0;
                    }
                    voiceurl=voiceurl.c_str();
                    char temp[voiceurl.length()];

                    for(i=0; (i<=voiceurl.length()); i++) {
 
                        temp[i]=voiceurl[i];

                    }


                    FILE *fp = fopen(ct[counter], "w");
                    if(fp == NULL) {
                        error("Could not open file for write\n");
                    }
                    fprintf(fp, temp);
                    fclose(fp);
                    printf("stored: _____ %s\n\n",temp);
                    printf("Goodbye World!\n");
                    counter++;

                    wait(.2);
                }
            } while (tsptr!=NULL); // No more "<title>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 1024); //Buffer has been read, now we can put more data in it
        }
    }
    lcd2.cls();
    if (result == HTTP_OK) {
        lcd2.cls();
        lcd2.printf(" Read complete\n\r");
    } else {
        lcd2. printf(" Error %d\n", result);

    }

free (BigBuf);
}
