#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread


InterruptIn button(PTD0);
DigitalOut led(LED_BLUE);
DigitalOut led2(LED_RED);
InterruptIn button2(PTD5);



volatile int pressEvent = 0 ;
volatile int pressEvent2 = 0 ;

volatile bool pressed1 = false;
volatile bool pressed2 = false;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback(){
    pressEvent = 1 ;
}

void buttonCallback2(){
    pressEvent2 = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button.mode(PullUp);             // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;   // Attach function to falling edge
    
    button2.mode(PullUp);             // Ensure button i/p has pull up
    button2.fall(&buttonCallback2) ;   // Attach function to falling edge

    while(true) {
        // Toggle the LED every time the button is pressed
        if (pressEvent) {
            pressEvent = 0; // Clear the event variable
            pressed1 = !pressed1;
        }
        if (pressEvent2) {
            pressEvent2= 0 ; // Clear the event variable
            pressed2= !pressed2;
        }
         if(!pressed1)
        {
            led = !led ;
        }
        if(!pressed2) {
            led2= !led2;
        }
        Thread::wait(500) ;
    }
}