#include "mbed.h"
#include "rtos.h"
#include "TSISensor.h"

// Example program for lab 5
// -------------------------
//  A value is read from the touch sensor and use
//    to control two LEDs
//  The value is also output to the serial interface

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut redLED(LED_RED);
DigitalOut greenLED(LED_GREEN);
DigitalOut blueLED(LED_BLUE);

TSISensor tsi;

Thread redThread(osPriorityNormal, 1000); // thread for red LED
Thread greenThread(osPriorityNormal, 1000); // thread for green LED
Thread blueThread(osPriorityNormal, 1000); // thread for green LED
Thread allThread(osPriorityNormal, 1000); // thread for green LED
 
void red_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        redLED = false ; // turn on 
        Thread::wait(5000);
        redLED = true ; // turn off 
        redThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void green_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        greenLED = false ; // turn on 
        Thread::wait(5000);
        greenLED = true ; // turn off 
        greenThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void blue_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        blueLED = false ; // turn on 
        Thread::wait(5000);
        blueLED = true ; // turn off 
        redThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

void all_thread() {  // method to run in thread
    while (true) {
        Thread::signal_wait(0x1);
        redLED = false;
        greenLED = false ; // turn on 
        blueLED = false;
        Thread::wait(5000);
        greenLED = true ; // turn off 
        redLED = true;
        blueLED = true;
        greenThread.signal_clr(0x1) ;
          // Signal are automatically cleared by wait_signal but
          // the signal might have been set again while LED on 
    }
}

enum softkeys {outer_left,inner_left,outer_right,inner_right, grey };

int main(void) {
    redLED = true ; // turn off 
    greenLED = true ; // turn off 
    redThread.start(&red_thread) ; // start the red thread
    greenThread.start(&green_thread) ; // start the green thread
    blueThread.start(&blue_thread) ; // start the blue thread
    allThread.start(&all_thread) ; // start the all thread
    
    softkeys key = grey;
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // Distance is between 0 and 39
            
        if(d>3 && d <9)
        {
            key = outer_left;
            redThread.signal_set(0x1) ;
            
        }
        else 
        if( d>13 && d < 19) 
        {
            key=inner_left;
            greenThread.signal_set(0x1) ;
            
        }else 
        if(d>23 && d < 29)
        {
            key = inner_right;
            blueThread.signal_set(0x1) ;
        }else 
        if(d>33)
        {
            key = outer_right;
            allThread.signal_set(0x1) ;
        }
        
        switch(key){
            case outer_left :
                if (d<3 || d >9 ) {    // 
                    key= grey;
                }
                break ;
             case inner_left :
                if (d<13 || d >19 ) {    //  
                    key= grey;
                }
                break ;
             case inner_right :
                if (d<23 || d >29 ) {    //  
                    key = grey;
                }
                break ;
             case outer_right :
                if (d<33) {    //  
                    key = grey;
                }
                break ;
            case grey:
                greenLED = true ; // turn off 
                redLED = true;
                blueLED = true;
                break;
        }
              
        pc.printf("%d", d) ;  
        pc.putc(' ') ;
      
        Thread::wait(200);  // This polling rate is too slow - increase it
                            // The slower rate maks it easier to output on the terminal
    }
}