#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
    float threshold = .50;
    float min_threshold = 0.25;
    


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        //flat
        if(z>threshold && abs(x)< min_threshold && abs(y)< min_threshold)
        {
          rled = 1.0f - abs(x);
          gled = 1.0f - abs(y);
          bled = 1.0f - abs(z);
          pc.printf("FLAT\n\r");
          pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
          
        }else
        if(y<-threshold && abs(z)<min_threshold && abs(x)<min_threshold)
        {
            rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
            pc.printf("RIGHT\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(y>threshold && abs(z)<min_threshold && abs(x)<min_threshold)
        {
            rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
            pc.printf("LEFT\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(x< -threshold && abs(z)<min_threshold && abs(y)<min_threshold)
        {
            rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
            pc.printf("DOWN\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(x> threshold && abs(z)<min_threshold && abs(y)<min_threshold)
        {
            rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
            pc.printf("UP\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }else
        if(z<-threshold && abs(y)<min_threshold && abs(x)<min_threshold)
        {
            rled = 1.0f - abs(x);
        gled = 1.0f - abs(y);
        bled = 1.0f - abs(z);
            pc.printf("OVER\n\r");
            pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        }
        else{
            rled = 1;
            gled= 1;
            bled =1;
            }
        Thread::wait(300);
        
    }
}
