#include "mbed.h"
#include "rtos.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;

#define MMA8451_I2C_ADDRESS (0x1d<<1)
  
Thread pollT;
Timer timer;
Ticker tick;

enum accelerometerPos { flat, left, right, up, down, over, failure, trigger };


int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(LED1);
    PwmOut gled(LED2);
    PwmOut bled(LED3);
    Serial pc(USBTX, USBRX); // tx, rx
        float threshold = .50;
    float min_threshold = 0.25;




    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    
    accelerometerPos pos = flat;
    bool restart = true;

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        

       if(pos!=trigger){ 
        
       if(z>threshold && abs(x)< min_threshold && abs(y)< min_threshold)
        {
            if(pos==failure)
            {
                if(restart){
                    timer.reset();
                    timer.start();
                    restart = false;
                }
                if(timer.read()>=10)
                {
                    rled=0;
                    gled=0;
                    bled=0;
                    pos= flat;
                    timer.reset();
                    restart = true;
                    
                }
            }else
            if(pos==up && timer.read()>=4 && timer.read()<=8)
            {
                rled=1;
                gled=0;
                bled=1;
                pc.printf("TRIGGER!!!!\n\r");
                pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
                pc.printf("Time taken was: %f \n\r",timer.read());
                pos = trigger;
                
            }else if(pos!=trigger){
                  pc.printf("FLAT\n\r");
                  pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
                  timer.start();
                  pos = flat;
                  pc.printf("Time taken was: %f \n\r",timer.read());
                }

          
        }else
        if(y<-threshold && abs(z)<min_threshold && abs(x)<min_threshold)
        {
            if(pos==flat && timer.read()>=10)
            {
                    pc.printf("RIGHT\n\r");
                    pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
                    pc.printf("The time taken was: %f seconds\n\r",timer.read());
                    pos = right;
                    timer.reset();
                    timer.start();
            }else if(pos!=right){
                    rled=0;
                    gled=1;
                    bled=1;
                    pc.printf("ERROR in time sequence, time taken: %f \n\r",timer.read());
                    pos = failure;
                }
                
                pc.printf("The time taken was: %f seconds\n\r",timer.read());
            
        }else
        if(x< -threshold && abs(z)<min_threshold && abs(y)<min_threshold)
        {
            if(pos == right && timer.read()>=2 && timer.read()<=6)
            {
                pc.printf("UP\n\r");
                pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
                pc.printf("The time taken was: %f seconds\n\r",timer.read());
                pos = up;
                timer.reset();
                timer.start();
            }else if(pos!=up) {
                    rled=0;
                    gled=1;
                    bled=1;
                    pc.printf("ERROR in time sequence, time taken: %f \n\r",timer.read());
                    pos = failure;
                }
            pc.printf("The time taken was: %f seconds\n\r",timer.read());
        }
        }
        
        
        
        
        
        
        
        
        Thread::wait(300);
        //timer.stop();
        
        pc.printf("X: %1.2f, Y: %1.2f, Z: %1.2f\n\r", x, y, z);
        
    }
}
