#include "mbed.h"

DigitalOut myled(LED1);
AnalogIn Ain(p20);  //defines analog input on Pin 20

BusOut Seg1 (p5,p6,p7,p8,p9,p10,p11,p12); // ABCDEFGDp, p5 je LSB

char SegConvert(char SegValue) {  // function "SegConvert"
    char SegByte=0x00;
    switch (SegValue) {                    // DpGFEDCBA
        case 0: SegByte = 0xC0; break;      // 00111111
        case 1: SegByte = 0xF9; break;      // 00000110
        case 2: SegByte = 0xA4; break;      // 01011011
        case 3: SegByte = 0xB0; break;      // 01001111
        case 4: SegByte = 0x99; break;      // 01100110
        case 5: SegByte = 0x92; break;      // 01101101
        case 6: SegByte = 0x82; break;      // 01111101
        case 7: SegByte = 0xF8; break;      // 00000111
        case 8: SegByte = 0x80; break;      // 01111111
        case 9: SegByte = 0x90; break;      // 01101111
    }
    return SegByte;
 }
 char prikaz;
 float Aout;
 
int main() {
    while(1) {
    for (char i=0; i>9;i++){
         prikaz = SegConvert(i);
         Seg1= prikaz;
         wait(1.5);
         }
    Aout=Ain;     //transfer analog in value to analog out
    Aout = Aout * 10.0;
    char ch = (char)Aout;
    Seg1= SegConvert(ch);
    wait(0.5);
    
    }
}
