#include "mbed.h"
#include "TextLCD.h"
#include "DHT.h"

TextLCD lcd(p19, p20, p21, p22, p23, p24, TextLCD::LCD8x2);
DHT sensor(p26, DHT11);
DigitalOut myled(p25);
AnalogIn Ain(p17);

int err;
float c, h, alarm;
int main()
{
    while (1) {
        wait(2);
        err = sensor.readData();
        alarm=Ain*50.0;
        if (err == 0) {
            c = sensor.ReadTemperature(CELCIUS);
            h = sensor.ReadHumidity();
            lcd.locate(0, 0);
            lcd.printf("T %3.1f ", c);
            lcd.locate(1, 1);
            lcd.printf("H %3.1f ", h);
            if(c>alarm) {
                myled=true;
            } else {
                myled=false;
            }
            wait(0.5);
        }
    }
}