#include "mbed.h"
#include "Motor.h"

AnalogIn ainSensA(p17);
AnalogIn ainSensB(p18);
AnalogIn ainSensC(p19);
AnalogIn ainSensD(p20);

int valAzimut = 0;
int valElevacija = 0;
float SensA, SensB, SensC, SensD;

int main() {

    Motor *motorEl = new Motor(p25, p26, p24);
    Motor *motorAz = new Motor(p22, p21, p23);
    
    (*motorAz).stop();
    (*motorEl).stop();
    
    while(1) {
    SensA= 0;   // initiate values before averaging
    SensB= 0;
    SensC= 0;
    SensD= 0;
    for (int i=0; i<=9; i++) {  
        SensA= SensA + ainSensA;  //get 10 samples of sensors values
        SensB= SensB + ainSensB;
        SensC= SensC + ainSensC;
        SensD= SensD + ainSensD;
    }
    SensA= SensA/10;
    SensB= SensB/10;
    SensC= SensC/10;
    SensD= SensD/10;
        
        valAzimut = (SensA + SensB) - (SensC + SensD); 
        valElevacija = (SensB + SensC) - (SensA + SensD);
        
        if (valAzimut > 0.2){
        // positive azimuth deviation
            (*motorAz).movePositiveSlow();
        }
        else if (valAzimut < -0.2) {
        // negative azimuth deviation
            (*motorAz).moveNegativeSlow();
        }
        (*motorAz).stopslow(); 
        
        if (valElevacija > 0.2){
        // positive azimuth deviation
            (*motorEl).movePositiveSlow();
        }
        else if (valElevacija < -0.2) {
        // negative azimuth deviation
            (*motorEl).moveNegativeSlow();
        }
        (*motorEl).stopslow(); 
        
        /*        
        (*motorEl).stop();        
        (*motorEl).movePositive();        
        (*motorEl).moveNegative();        
        */
    
    }
}
