#include "Motor.h"

Motor::Motor(PinName positivePin, PinName negativePin, PinName enablePin): positiveOut(positivePin), negativeOut(negativePin), enableOut(enablePin) {
enableOut.period(0.010);  // set PWM period to 10 ms
}

void Motor::movePositive() {

    direction = 1;
    move();
}

void Motor::moveNegativeSlow() {

    direction = -1;
    moveslow();
}
void Motor::movePositiveSlow() {

    direction = 1;
    moveslow();
}

void Motor::moveNegative() {

    direction = -1;
    move();
}
void Motor::move() {

    positiveOut = 0;
    negativeOut = 0;
        
    switch(direction) {    
    case 0:
        return;
    case 1:
        positiveOut = 1;
        break;
    case -1:
        negativeOut = 1;
        break;
    }
    
    wait_ms(motorDriveTime);
}
void Motor::moveslow() {

    positiveOut = 0;
    negativeOut = 0;
        
    switch(direction) {    
    case 0:
        return;
    case 1:
        positiveOut = 1;
        break;
    case -1:
        negativeOut = 1;
        break;
    }
    for (int i=0; i<1; i=i+0.1) { // slow running start 0.5 s
        enableOut= i;
        wait(0.05);
    }
    wait_ms(motorDriveTime);
}
void Motor::initpwm() {

    enableOut.period(0.010);  // set PWM period to 10 ms
    enableOut = 0.5;  // set initial duty cycle to 50%
}
void Motor::stop() {

    positiveOut = 0;
    negativeOut = 0;
    direction = 0;
}
void Motor::stopslow() {

    for (int i=1; i>0; i=i-0.1) {
        enableOut= i;
        wait(0.05);
    }
    positiveOut = 0;
    negativeOut = 0;
    direction = 0;
}
