#include "mbed.h"
#include "Motor.h"
#include "TextLCD.h"

#define sensorStartTreshold     0.08
#define sensorStopTreshold      0.02

#define calibrateFactorSenzA    1
#define calibrateFactorSenzB    0.97
#define calibrateFactorSenzC    1.06
#define calibrateFactorSenzD    0.9

#define lcdOutputEnable         true
#define serialOutputEnable      false
#define serialOutputBaudrate    115200

Serial pc(USBTX, USBRX);
TextLCD lcd(p13, p14, p5, p6, p7, p8); // rs, e, d4-d7

DigitalOut ledBoot(LED1);
DigitalOut ledAz(LED3); 
DigitalOut ledEl(LED4);

AnalogIn ainSensA(p16);
AnalogIn ainSensB(p17);
AnalogIn ainSensC(p18);
AnalogIn ainSensD(p19);

float valAzimut = 0;
float valElevacija = 0;

float SensA, SensB, SensC, SensD;
void readValuesForAveraging() {

    SensA = 0;
    SensB = 0;
    SensC = 0;
    SensD = 0;
    
    for (int i = 0; i < 20; i++) {  
        SensA += ainSensA;
        SensB += ainSensB;
        SensC += ainSensC;
        SensD += ainSensD;
    }
    SensA /= 20;
    SensB /= 20;
    SensC /= 20;
    SensD /= 20;
        
    SensA *= calibrateFactorSenzA;
    SensB *= calibrateFactorSenzB;
    SensC *= calibrateFactorSenzC;
    SensD *= calibrateFactorSenzD;
        
    valAzimut = (SensA + SensB) - (SensC + SensD); 
    valElevacija = (SensB + SensC) - (SensA + SensD);
    
    if(serialOutputEnable) {
    
//    pc.printf("az:%6.3f el:%6.3f :: A:%.3f B:%.3f C:%.3f D:%.3f \n", 
//            valAzimut, valElevacija, SensA, SensB, SensC, SensD);

     //   pc.printf("az:%6.3f el:%6.3f \n", valAzimut, valElevacija);
    }
    
    if(lcdOutputEnable) {
        lcd.cls();
        lcd.printf("a:%5.2f \n", valAzimut);    
        lcd.printf("e:%5.2f \n", valElevacija);    
    }
    
}

int main() {   

    ledBoot = 1;
    pc.baud(serialOutputBaudrate);
    Motor *motorAz = new Motor(p28, p27, p26); // relej, relej, pwm
    Motor *motorEl = new Motor(p24, p23, p25);
    if(lcdOutputEnable) {
        lcd.cls();
        lcd.printf("Suncokre\n");    
        lcd.printf("t  TVZ  \n");    
    }
    wait_ms(5000);
    ledBoot = 0;

    while(1) {

// ---- citanje senzora ------------    
    
        readValuesForAveraging();
        
// ----- azimut -----
        
        if(abs(valAzimut) > sensorStartTreshold) {
            if(valAzimut > 0) 
                (*motorAz).movePositive();
            else
                (*motorAz).moveNegative();
            ledAz = 1;
        }
        
        if(abs(valAzimut) < sensorStopTreshold) {
            (*motorAz).stop();
            ledAz = 0;
        }
        
// ----- elevacija -----

        if(abs(valElevacija) > sensorStartTreshold) {
            if(valElevacija > 0) 
                (*motorEl).movePositive();
            else
                (*motorEl).moveNegative();
            ledEl = 1;
        }
        
        if(abs(valElevacija) < sensorStopTreshold) {
            (*motorEl).stop();
            ledEl = 0;
        }
        
// ----- pauza ------

        wait_ms(100);        
    }
}


