#ifndef MOTOR_H
#define MOTOR_H

#include "mbed.h"

#define motorDriveTime          100    // vrijeme koje se motor kreće, u milisekundama.
#define motorPwmPeriod          0.010   // PWM period to 10 ms
#define motorPwmInitDutyCycle   0.5     // PWM initial duty cycle, 50%
#define motorPwmWaitTime        0.02    // PWM wait time in sec.
#define motorPwmChangeSpeed     0.2     // PWM value change

class Motor {

private:
    DigitalOut positiveOut, negativeOut;
    PwmOut pwmOut;
    short direction;    
    void start();

public:
    Motor(PinName, PinName, PinName);
    void movePositive();
    void moveNegative();
    void stop(); 
    bool isMoving();   
    
};

#endif
