#include "mbed.h"

Serial async_port(p9, p10);          //set up TX and RX on pins 9 and 10
DigitalOut red_led(LED4);             //red led
DigitalOut green_led(LED3);           //green led
DigitalOut RXDIN (LED1);

DigitalIn switch_ip1(p5);
DigitalIn switch_ip2(p6);
DigitalIn switch_ip3(p7);
DigitalIn switch_ip4(p8);

Serial pc(USBTX, USBRX); 

char header_read ;                   //first byte we will send
char param_ads;                      // parameter address
char recd_val;                       //the received value
int valueADC;
char Outbuff[12];
char Inbuff[12];
int valueSensA, valueSensB, valueSensC, valueSensD;
float fAzimuthErr;
float fElevationErr;
float fSensACalib;
unsigned char *pointnavar;

int main()
{
    async_port.baud(9600);             //set baud rate to 9600 (ie default)
    switch_ip1.mode(PullUp);            // Pull up internal resistor
    switch_ip2.mode(PullUp);
    switch_ip3.mode(PullUp);
    switch_ip4.mode(PullUp);
    fSensACalib= 35.77;

    //accept default format, of 8 bits, no parity
    while (1) {

        // read or write mode ?
        if (switch_ip1==0) {
            header_read=0x10;                 // read output pattern
            if (switch_ip2==0) {
                param_ads = 0;
            } else {
                param_ads = 1;
            }

            /*
            valueADC = 0x0302;
            Outbuff[0] = valueADC;
            Outbuff[1] = valueADC >> 8; */

            while (async_port.writeable()==0);  //is there a place to write?
            async_port.putc(header_read);       //transmit haeder
            while (async_port.writeable()==0);  //is there a place to write?
            async_port.putc(param_ads);         //transmit parameter address



            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[0] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[1] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[2] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[3] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[4] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[5] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[6] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[7] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[8] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[9] = async_port.getc();     //if yes, t
            }
            if (async_port.readable()==1) {    //is there a character to be read?
                Inbuff[10] = async_port.getc();     //if yes, t
            }

            RXDIN = 1;
            wait(1);
            RXDIN = 0;
            if (param_ads==0x00) {
                valueSensA = Inbuff[2]+ Inbuff[3]*256;
                valueSensB = Inbuff[4]+ Inbuff[5]*256;
                valueSensC = Inbuff[6]+ Inbuff[7]*256;
                valueSensD = Inbuff[8]+ Inbuff[9]*256;
                pc.printf("SensA:  %d  SensB:  %d SensC:  %d  SensD:  %d \n\r", valueSensA, valueSensB, valueSensC, valueSensD);
            }
            if (param_ads==0x01) {
                pointnavar = (unsigned char*) &fAzimuthErr;
                for (int i=2; i<6; i++) {
                    *pointnavar = Inbuff[i];
                    pointnavar++;
                }
                pointnavar = (unsigned char*) &fElevationErr;
                for (int i=6; i<10; i++) {
                    *pointnavar = Inbuff[i];
                    pointnavar++;
                }
                pc.printf("AZIMUT:  %+3.0f  ELEVATION; %+3.0f  \n\r",   fAzimuthErr, fElevationErr);
            }
        } // if (switch_ip1==0)

        else {
            header_read=0x20;                 //   write output pattern
            Outbuff[0] = header_read;
            param_ads = 2;      // parameter to write
            Outbuff[1] = param_ads;
            pointnavar = (unsigned char*) &fSensACalib;
            for (int i=2; i<6; i++) {
                Outbuff[i] = *pointnavar ;
                pointnavar++;
            }
            Outbuff[6]=0;           // checksum
            for (int i=0; i<6; i++)
                {  Outbuff[6] += Outbuff[i];            
                }
             

            for (int i=0; i<7; i++) {
                while (async_port.writeable()==0);  //is there a place to write?
                async_port.putc(Outbuff[i]);       //transmit byte
            }
            RXDIN = 1;
            wait(1);
            RXDIN = 0;


        } // else
    }  // while(1)
}  //main
