/**
* Copyright (c)2010 ARM Ltd.
* Released under the MIT License: http://mbed.org/license/mit
*/
#include "mbed.h"
#include "SerialRPCInterface.h"


using namespace mbed;

//Create the interface on the USB Serial Port
SerialRPCInterface RPC(USBTX, USBRX, 9600); // it defaults to 9600 if you don't put the baud Paramete in but I've put it in so can be changed
void SetTime(char * input, char * output);
RPCFunction TimeSet(&SetTime, "TimeSet");
DigitalOut myled(LED1);

int main() {

    while(1) {    
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

// REM to call this function via RPC TimeSet
void SetTime(char * input, char * output){
    time_t time_value = time_t(input);
    set_time(time_value); 
    time_t seconds = time(NULL);
    sprintf(output, "\r\n Time as seconds since January 1, 1970 = %d\r\n", seconds); // puts String into "output" for SerialRPC to process and transmit
}

// so set up terminal up to 9600 baud and type "/TimeSet/run 232323" 
 