#include "mbed.h"

#include "motorcar.h"

DigitalOut led1(LED1); // LED indicating car is running
DigitalIn pb(USER_BUTTON); // car activate button
int lastButtonState = 0;
bool ledState = false;

// main() runs in its own thread in the OS
int main() {
    //init();
    
    while (true) {
        int reading1 = pb.read();

        if(reading1 != lastButtonState) {
            wait_ms(20);

            int reading2 = pb.read();

            if(reading2 == reading1) {
                lastButtonState = reading2;
            }

            if(lastButtonState == 1) {
                ledState = !ledState;
            }
        }

        led1.write(ledState);
        
        if(ledState) {
            readSensorValue();
            
            runPID();
        }
    }
}

