#ifndef AUTOCAR_H
#define AUTOCAR_H

#include "mbed.h"

#include "Ping.h"

// used for motors
extern DigitalOut M1_enable;
extern DigitalOut M2_enable;
extern DigitalOut M1_in1;
extern DigitalOut M1_in2;
extern DigitalOut M2_in3;
extern DigitalOut M2_in4;

// used for IR sensors
extern AnalogIn leftIR;
extern AnalogIn middleIR;
extern AnalogIn rightIR;

// used for ultrasonic sensors
extern Ping ultrasonic;

// read the value of IR sensors
void readIR(bool* left, bool* middle, bool* right, int threshold);
int readIRValues();
void readSensor(bool* left, bool* middle, bool* right, bool* hasObstacle, int threshold, int range);
void readSensorValues(int *values, bool *hasObstacle, int range);

long map(long x, long in_min, long in_max, long out_min, long out_max);

// used for controlling the direction of auto car
void DriveSingleMotor(int m, int speed, int dir);
void driveMotor(bool left, bool middle, bool right);
void driveMotor(bool left, bool middle, bool right, bool hasObstacle);
void driveMotorPID(int values, float Kp, float Ki, float Kd);
void run(int values, float Kp, float Ki, float Kd, bool hasObstacle);

void init();
void stop();
void forward();
void turnLeft();
void turnRight();

#endif