
#include "stm32l475e_iot01_gps.h"
#include <stdio.h>
#include <string.h>
 
Serial pc1(USBTX, USBRX);
 
GPS::GPS(PinName tx, PinName rx) : _gps(tx, rx) {
    _gps.baud(9600);
      
    longitude = 0.0;
    latitude = 0.0;
    ns = 'N';
    ew = 'E';
    alt = 0.0;
            
}

int GPS::sample() {
    float time, knots, angle, mag, mag_angle;
    int date, checksum;
   
    char lock;
    
    while(1) {        
        getline();
        // Check if it is a GPGGA msg (matches both locked and non-locked msg)
        //pc1.printf(msg);
        pc1.printf("\n");
        wait(5);
        pc1.printf("display msg\r\n");
        pc1.printf(msg);
        pc1.printf("\n");
        if(sscanf(msg, "GPRMC,%f,%c,%f,%c,%f,%c,%f,%f,%d,%f,%f*%d", &time, &lock, &latitude, &ns, &longitude, &ew, &knots, &angle, &date, &mag, &mag_angle, &checksum) >= 1) { 
            if(lock=='V') {
                pc1.printf("not valid!!!!!!!\n");
                longitude = 0.0;
                latitude = 0.0;  
                ns = 'Z';
                ew = 'Z';
                date =0;      
                return 0;
            } else {
                //if(ns == 'S') {    latitude  *= -1.0; }
//                if(ew == 'W') {    longitude *= -1.0; }
//                float degrees = trunc(latitude / 100.0f);
//                float minutes = latitude - (degrees * 100.0f);
//                latitude = degrees + minutes / 60.0f;    
//                degrees = trunc(longitude / 100.0f * 0.01f);
//                minutes = longitude - (degrees * 100.0f);
//                longitude = degrees + minutes / 60.0f;
//                pc1.printf(msg);
                pc1.printf("\n\rlongitude is %f\n\r", longitude);
                pc1.printf("\n\rtime is %f\n\r", time);
                pc1.printf("ns is %c\n\r", ns);
                pc1.printf("ew is %c\n\r", ew);
                pc1.printf("alt is %d\n\r", date);
                
                latitude /= 100;
                longitude /= 100;
                
                return 1;
            }
        
        }
        return 0;
    }
}
 
float GPS::trunc(float v) {
    if(v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}
 
void GPS::getline() {
    int i;
    char a;
    int n;
    while(1) {
    memset(msg, '\0', sizeof(msg));
    pc1.printf("\r\n\n New Message: ");
    pc1.printf(msg);
    pc1.printf("\r\n\n");    
    i = 0;
    pc1.printf("waiting...\n");
    a = _gps.getc();
    msg[i] = a;
    if (a == '$') {
        pc1.printf("%c",a);
        msg[i]=a;
        a = _gps.getc();
        while(a!='$'){
            msg[i] = a;
            i++;            
            printf("%c",a);
            a = _gps.getc();
        }
        return;
//        msg[i] = a;
//        i++;
//        if (a == 'G') {
//            pc1.printf("%c",a);
//            a = _gps.getc();
//            msg[i] = a;
//            i++;
//            if (a == 'P') {
//                pc1.printf("%c",a);
//                a = _gps.getc();
//                msg[i] = a;
//                i++;
//                if (a == 'R') {
//                    pc1.printf("%c",a);
//                    a = _gps.getc();
//                    msg[i] = a;
//                    i++;
//                    if (a == 'M') {
//                        pc1.printf("%c",a);
//                        a = _gps.getc();
//                        msg[i] = a;
//                        i++;
//                        if (a == 'C') {
//                            pc1.printf("%c",a);
//                            a = _gps.getc();
//                            msg[i] = a;
//                            pc1.printf(msg);
//                            pc1.printf("\r\n");
//        
//                            for (n = 5; n < 456; n++) {
//                               msg[n] = _gps.getc();
//                               pc1.printf("%c", msg[n]);
//                               if(msg[n] == '\r') {
//                                 msg[n] = '0';
//                                 return;
//                                }
//                            }
//                         }
//                     }
//                 }
//            }
//       }
    }                          
//    while(_gps.getc() != '$') {
//        //char a = _gps.getc();
//        for(i = 0; i < 256; i++) {
//            msg[i] = _gps.getc();
//            pc1.printf("%c", msg[i]);
//            if(msg[i] == '\r') {
//             msg[i] = 0;
//             return;
//                }
//                }
//          
//         
//    }
//    while(_gps.getc() != '$');    // wait for the start of a line
//    for(int i=0; i<256; i++) {
//        msg[i] = _gps.getc();
//        if(msg[i] == '\r') {
//            msg[i] = 0;
//            return;
//        }
//    }
//    error("Overflowed message limit");
}
}