/* WiFi Example
 * Copyright (c) 2018 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */



#include "ThisThread.h"
#include "mbed.h"
#include "TCPSocket.h"
//#include "TCPServer.h"
#include "stm32l475e_iot01_accelero.h"
#include "stm32l475e_iot01_gps.h"


#define WIFI_IDW0XX1    2

#if (defined(TARGET_DISCO_L475VG_IOT01A) || defined(TARGET_DISCO_F413ZH))
#include "ISM43362Interface.h"
ISM43362Interface wifi( false);

#else // External WiFi modules

#if MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1
#include "SpwfSAInterface.h"
SpwfSAInterface wifi(MBED_CONF_APP_WIFI_TX, MBED_CONF_APP_WIFI_RX);
#endif // MBED_CONF_APP_WIFI_SHIELD == WIFI_IDW0XX1

#endif

#define SCALE_MULTIPLIER    0.004


GPS* gps=new GPS(D1,D0);

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;

    printf("Scan:\n");

    int count = wifi->scan(NULL,0);
    printf("%d networks available.\n", count);

    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;

    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    for (int i = 0; i < count; i++)
    {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }

    delete[] ap;
    return count;
}

void acc_server(NetworkInterface *net)
{
    /* 
    TCPServer socket;
    TCPSocket* client;*/
    TCPSocket socket;
    SocketAddress addr("192.168.43.163",65431);
    nsapi_error_t response;

    int16_t pDataXYZ[3] = {0};
    char recv_buffer[9];
    char acc_json[64];
    int sample_num = 0;
    
    //analyze
    float bufX[80], bufY[80], bufZ[80];
    int saX[80]={0}, saY[80]={0}, saZ[80]={0};
    int fuzX[3]={80,0,0}, fuzY[3]={80,0,0}, fuzZ[3]={80,0,0};
    int stX=0, stY=0, stZ=0;
    int ptr=0;
    int i=0;
    /*
    for(i=0;i<80;i++){
        saX[i]=0;
        saY[i]=0;
        saZ[i]=0;
    }
    */

    // Open a socket on the network interface, and create a TCP connection to addr
    response = socket.open(net);
    if (0 != response){
        printf("Error opening: %d\n", response);
    }
    response = socket.connect(addr);
    
    if (0 != response){
        printf("Error connecting: %d\n", response);
    }


    socket.set_blocking(1);
    while (1){
        ptr=sample_num%80;
        ++sample_num;
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        float x = pDataXYZ[0]*SCALE_MULTIPLIER, y = pDataXYZ[1]*SCALE_MULTIPLIER, z = pDataXYZ[2]*SCALE_MULTIPLIER;
        int len;
        
        bufX[ptr]=x;
        bufY[ptr]=y;
        bufZ[ptr]=z;
        
        fuzX[saX[ptr]]-=1;
        if(x>1){
            saX[ptr]=2;
            fuzX[2]+=1;
        }else if(x>-1){
            saX[ptr]=1;
            fuzX[1]+=1;
        }else{
            saX[ptr]=0;
            fuzX[0]+=1;
        }
        fuzY[saX[ptr]]-=1;
        if(y>1){
            saY[ptr]=2;
            fuzY[2]+=1;
        }else if(y>-1){
            saY[ptr]=1;
            fuzY[1]+=1;
        }else{
            saY[ptr]=0;
            fuzY[0]+=1;
        }
        fuzZ[saX[ptr]]-=1;
        if(z>5){
            saZ[ptr]=2;
            fuzZ[2]+=1;
        }else if(z>3){
            saZ[ptr]=1;
            fuzZ[1]+=1;
        }else{
            saZ[ptr]=0;
            fuzZ[0]+=1;
        }
        
        //fuzzy
        //X
        if(fuzX[2]>64 || fuzX[0]>64){
            if(stX!=3){
                len = sprintf(acc_json,"x3\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stX=3;
            }
        }else if((fuzX[2]>32 || fuzX[0]>32) && fuzX[1]>32){
            if(stX!=2){
                len = sprintf(acc_json,"x2\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stX=2;
            }
        }else if(fuzX[2]>32 && fuzX[0]>32){
            if(stX!=1){
                len = sprintf(acc_json,"x1\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stX=1;
            }
        }else if(fuzX[1]>64){
            stX=0;
        }
        //Y
        if(fuzY[2]>64 || fuzY[0]>64){
            if(stY!=3){
                len = sprintf(acc_json,"y3\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stY=3;
            }
        }else if((fuzY[2]>32 || fuzY[0]>32) && fuzY[1]>32){
            if(stY!=2){
                len = sprintf(acc_json,"y2\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stY=2;
            }
        }else if(fuzY[2]>32 && fuzY[0]>32){
            if(stY!=1){
                len = sprintf(acc_json,"y1\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stY=1;
            }
        }else if(fuzY[1]>64){
            stY=0;
        }
        //Z
        if(fuzZ[2]>64 || fuzZ[0]>64){
            if(stZ!=3){
                len = sprintf(acc_json,"z3\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stZ=3;
            }
        }else if((fuzZ[2]>32 || fuzZ[0]>32) && fuzZ[1]>32){
            if(stZ!=2){
                len = sprintf(acc_json,"z2\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stZ=2;
            }
        }else if(fuzZ[2]>32 && fuzZ[0]>32){
            if(stZ!=1){
                len = sprintf(acc_json,"z1\n");
                response = socket.send(acc_json,len);
                int v=gps->sample();
                if(v){len=sprintf(acc_json,"%f,%f",gps->longitude,gps->latitude);}
                else{len=sprintf(acc_json,"N");}
                response = socket.send(acc_json,len);
                stZ=1;
            }
        }else if(fuzZ[1]>64){
            stZ=0;
        }
        
        //int len = sprintf(acc_json,"%f,%f,%f,%d,%d\n",(float)((int)(x*10000))/10000,
        //                                (float)((int)(y*10000))/10000, (float)((int)(z*10000))/10000, sample_num, ptr);

            
        //response = socket.send(acc_json,len);
        if (0 >= response){
            printf("Error seding: %d\n", response);
        }
        ThisThread::sleep_for(0.1);
    

    }

 
    socket.close();
}

int main()
{

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    //wifi.set_network("192.168.130.105","255.255.255.0","192.168.130.254");
    int ret = wifi.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error\n");
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi.get_mac_address());
    printf("IP: %s\n", wifi.get_ip_address());
    printf("Netmask: %s\n", wifi.get_netmask());
    printf("Gateway: %s\n", wifi.get_gateway());
    printf("RSSI: %d\n\n", wifi.get_rssi());



    BSP_ACCELERO_Init();    


    acc_server(&wifi);



}
