#include "mbed.h"
DigitalOut pt(PC_4);

Serial pc(USBTX, USBRX);
 
void SystemClock_Config(void);

      
int main()
{
   int dbgCount;

   dbgCount=0;
   //SystemClock_Config();
   pc.baud(115200);
   printf("CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);  
   while(1)
   {
        printf("\r\n%d",dbgCount++);
        wait(1);   
   }
}

void SystemClock_Config(void)
{
     GPIO_InitTypeDef InitStruct;
    
    
    RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};
    RCC_OscInitTypeDef RCC_OscInitStruct = {0};
 
    /* MSI 2 MHz as source clock for Low Power Run mode */
    RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_MSI;
    RCC_OscInitStruct.MSIState = RCC_MSI_ON;
    RCC_OscInitStruct.MSIClockRange = RCC_MSIRANGE_5; // 2 MHz
    RCC_OscInitStruct.MSICalibrationValue = RCC_MSICALIBRATION_DEFAULT;
    RCC_OscInitStruct.PLL.PLLState = RCC_PLL_OFF;
    if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK) {
        // Error
    }
 
    /* Select PLL as system clock source and configure the HCLK, PCLK1 and PCLK2
       clocks dividers */
    RCC_ClkInitStruct.ClockType = (RCC_CLOCKTYPE_SYSCLK | RCC_CLOCKTYPE_HCLK | RCC_CLOCKTYPE_PCLK1 | RCC_CLOCKTYPE_PCLK2);
    RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_MSI;
    RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
    RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
    RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;
    if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_0) != HAL_OK) {
        printf("\r\n!!! MainClock configuration failure, case #1\r\n");
    }
 
    /* The voltage scaling allows optimizing the power consumption when the device is
       clocked below the maximum system frequency, to update the voltage scaling value
       regarding system frequency refer to product datasheet.  */
 
    /* Enable Power Control clock */
    __HAL_RCC_PWR_CLK_ENABLE();
 
    if (HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE2) != HAL_OK) {
        printf("\r\n!!! MainClock configuration failure, case #2\r\n");
    }
 
    /* Enter Low Power Run mode */
    HAL_PWREx_EnableLowPowerRunMode();
 
    /* Disable Power Control clock */
    __HAL_RCC_PWR_CLK_DISABLE();
 
    SystemCoreClockUpdate();
    
   ///////////////////////////////////Ouputing sysclock / 16 for control
    HAL_RCC_MCOConfig(RCC_MCO1, RCC_MCO1SOURCE_SYSCLK, RCC_MCODIV_16);   // select PLLCLK as source
 
 
    /*Configure GPIO pin to output clock signal at  PA8 */
      InitStruct.Pin = GPIO_PIN_8;
      InitStruct.Mode = GPIO_MODE_AF_PP;
      InitStruct.Pull = GPIO_NOPULL;
      InitStruct.Speed = GPIO_SPEED_HIGH;
      InitStruct.Alternate = GPIO_AF0_MCO;
      HAL_GPIO_Init(GPIOA, &InitStruct);  
} 