#include "mbed.h"
#include "ms5637.h"

ms5637 ms(PTE0, PTE1);                        // i2c pins used
Serial pc(USBTX, USBRX);                   // local terminal interface


int main (void)
{
    pc.baud(9600);                        // set up USB serial speed

    // set up the ms5611
    pc.printf("\n\nInitializing the MS5611..\n\r");
    ms.cmd_reset();
    pc.printf("Ready new\n\r");

    while(1) {
        double Temp = ms.calcTemp();                         //calculate press and temp, then returns current temperature in degC
        double Press = ms.calcPressure();                    //calculate press and temp, then returns current pressure in mb
        double GetPress = ms.getPressure();                  //returns current pressure in mb. Does no calculations.  Ususally done after calcTemp()
        double Altitude = ms.getAltitudeFT(1013.25);         //enter pressure at sea level in mb, returns altitude in feet
        double PressSeaLvlFT = ms.getSeaLevelBaroFT(327.2);  //enter known altitude in feet, returns sea level pressure in mb
        double PressSeaLvlM = ms.getAltitudeFT(99.73);       //enter known altitude in meters, returns seal level pressure in mb

        pc.printf("Temp: %.2f degC - ", Temp);
        pc.printf("Barometer: %.1f mB  %.3f in/Hg - \r", Press, Press * 0.0295301);
    //    pc.printf("Alt: %.1f ft - ", Altitude);
     //   pc.printf("Sea_Lvl: %.1f ft   %.2f m\r", PressSeaLvlFT, PressSeaLvlM);
        wait(2.0);
    }
}


