#include "mbed.h"
#include "TextLCD.h"

Serial xbee1(PTC4, PTC3);
DigitalOut rst1(PTC0);

DigitalOut myled(LED1);
DigitalOut myled2(LED2);

TextLCD lcd(PTC12,PTC13,PTC16,PTC17,PTA16,PTA17); // rs, e, d4-d7

int main() {
    rst1 = 0;   //Set reset pin to 0
    myled = 0;
    myled2= 0;
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);

    lcd.printf("starting");
    wait(2);
    lcd.cls();

    int a = 0;
    int prev = 0;

    while (1) {

        if(xbee1.readable()){
            prev = a;
            a = xbee1.getc(); //XBee read
            
            if (a != prev){
                if (a < 10){
                    lcd.printf("%d", a);
                }
                if (a == 254 || a == 253){
                    lcd.cls();
                }
            }
        }
    }
}
