#include "mbed.h"


DigitalOut T1(PTA13); // base for digit #1
DigitalOut T2(PTD5); // base for digit #2
DigitalOut T3(PTD0); // base for digit #3
DigitalOut T4(PTD2); // base for digit #4

// digital bus to send 8bit code for each 7 seg through
BusOut sseg(PTA1,PTC9,PTC8,PTA12,PTD4,PTA2,PTA4,PTA5);

Ticker dtimer;


//decoder for BCD to 7 segment =a-b-c-d-e-f-g-DP
int sbits[12]={
    0b11111100, //'0'
    0b01100000, //'1'
    0b11011010,  //'2'
    0b11110010, //'3'
    0b01100110, //'4'
    0b10110110, //'5'
    0b10111110, //'6'
    0b11100000, //'7'
    0b11111110, //'8'
    0b11110110, //'9'
    0b00000001  //'.' // decimal point
    };
    
int disp[4]={0,1,2,3}; // variable to store the current display on

int flash1(float tm){
    T1=1;
    wait(tm/2);
    T1=0;
    wait(tm/2);
    return(1);
    }
    
    
int flash2(float tm){
    T2=1;
    wait(tm/2);
    T2=0;
    wait(tm/2);
    return(1);
    }
    
    int flash3(float tm){
    T3=1;
    wait(tm/2);
    T3=0;
    wait(tm/2);
    return(1);
    }
    
    int flash4(float tm){
    T4=1;
    wait(tm/2);
    T4=0;
    wait(tm/2);
    return(1);
    }
    
    // update the display with one cycle of flashes
void dupdate(){
            
    sseg=~sbits[disp[0]];
    flash1(0.001);
    sseg=~sbits[disp[1]];
    flash2(0.001);
    sseg=~sbits[disp[2]];
    flash3(0.001);
    sseg=~sbits[disp[3]];
    flash4(0.001);
   
    }

// just cycle through leds in turn
int main() {
        dtimer.attach(&dupdate,0.01);
        T1=1;
    
        wait(1);
        int q;
        while(1){
        for(q=0;q<11;q++){
           
                disp[0]=q;
                disp[1]=(q+1)%10;
                disp[2]=(q+2)%10;
                disp[3]=(q+3)%10;
       wait(1);
            
        }
        
    }
}