// Integral Control
// Changdae Hahm and Charles Stabler
// LAB 4 ES202
// 26FEB15

#include "mbed.h"
#include "Motor.h"

Serial pc(USBTX, USBRX);   // initialize serial comms
AnalogIn ted(p19);         // pin for sensor
Motor m(p26,p29,p30);      // motor control
Timer t;

float k = 0.6; 
float height;
float read;
float mspd;
float err;
float integral_value;
int i = 0;

int main() {
    
    pc.baud(9600);
    pc.format(7,SerialBase::None,1);
    t.start();
    
    while(1) {
        while (i == 0) {     // top floor loop
            read = ted.read();
            height = ((495.425114818726*pow(read,3)) - (734.715379566225*pow(read,2)) + (358.613836921017*read) - 35.5785628052144)-3.5;
            pc.printf("%f,%f\n", height,t.read());
            err = 18.0 - height;
            integral_value += err*0.02;  // adds up power if not at correct height
            mspd = (k*err) + k*integral_value;
            m.speed(mspd);
            if(abs(err) <= 0.1){  // logic for stopping motor at desired height
                m.speed(0);
                i = 1;            // switching desired floors, exiting this loop
                integral_value = 0.0;  // clearing the integral value for next loop
            }
        }
        while(i == 1){       // bottom floor loop
            read = ted.read();
            height = ((495.425114818726*pow(read,3)) - (734.715379566225*pow(read,2)) + (358.613836921017*read) - 35.5785628052144)+1.5;
            pc.printf("%f,%f\n", height,t.read());
            err = 10.0 - height;
            integral_value += err*0.02;  // integrating error
            mspd = (k*err) + k*integral_value;
            m.speed(mspd);    
            if(abs(err) <= 0.1){  // stop at desired height
                m.speed(0);
                i = 0;            // switch desired floors and exit loop
                integral_value = 0.0;  // clearing the integral value for next loop
            }
        }
    }
}