
/* USB Keyboard extended example
 * This program will emulate an USB keyboard and
 * emits predefined key sequences when the corresponding
 * button was pressed
 *
 * Tested on NUCLEO-F446RE board with Arduino Multifunction Board using Mbed 2
 */
#include "mbed.h"
#include "USBKeyboard.h"

DigitalIn B1(BUTTON1,PullUp);
DigitalIn S1(A1,PullUp);
DigitalIn S2(A2,PullUp);
DigitalIn S3(A3,PullUp);
USBKeyboard keyboard;

int B1state = 1;
int S1state = 1;
int S2state = 1;
int S3state = 1;

int main(void)
{
    while (1) {
        if (B1state && !B1) {
            keyboard.mediaControl(KEY_VOLUME_DOWN);
            keyboard.printf("Hello World from Mbed USBKeyboard demo\r\n");
            keyboard.keyCode('s', KEY_CTRL);
            keyboard.keyCode(KEY_CAPS_LOCK);
            B1state = 0;
            wait(1);            
        } else if(!B1state && B1) B1state = 1;

        if (S1state && !S1) {
            keyboard.keyCode('r', KEY_LOGO);  // Windows kay + R key command
            keyboard.printf("https://megtestesules.info\r\n ");
            S1state = 0;
            wait(1);            
        }
        else if(!S1state && S1) S1state = 1;
        
        if (S2state && !S2) {
            keyboard.keyCode('r', KEY_LOGO);  // Windows key + R key command
            keyboard.printf("https://megtestesules.info/hobbielektronika/\r\n ");
            S2state = 0;
            wait(1);            
        }
        else if(!S2state && S2) S2state = 1;        

        if (S3state && !S3) {
            keyboard.keyCode('r', KEY_LOGO);  // Windows key + R key command
            keyboard.printf("https://cspista.hu/\r\n ");
            S3state = 0;
            wait(1);
        }
        else if(!S3state && S3) S3state = 1; 
        wait(0.02);
    }
}