
/* RTOS timer example
 * This program was borrowed from the book
 * 'ARM-Based microcontroller projects using MBED'
 * written by Dogan Ibrahim
 * Newsnes (an imprint of Elsevier) 2019. ISBN: 978-0-08-102969-5
 *
 * https://www.sciencedirect.com/book/9780081029695/arm-based-microcontroller-projects-using-mbed
 */

#include "mbed.h"
#include "rtos.h"
DigitalOut led(LED1);

void Flash() {
    led = !led;                  // Flash the LED
}

int main() {
    led = 1;
    RtosTimer timer(Flash);      // Create a timer
    timer.start(500);            // Start the timer
    Thread::wait(5000);          // Wait 5 seconds
    timer.stop();                // Stop the timer

    Thread::wait(osWaitForever); // Wait forever
}

