#include "mbed.h"
#include "rtos.h"
 
DigitalOut led(LED1);
osThreadId mainThreadID;
 
void signal_thread(void const *argument) {
    while (true) {
        Thread::wait(1000);
        osSignalSet(mainThreadID, 0x1);
    }
}
 
int main (void) {
    mainThreadID = Thread::gettid();
    Thread thread(signal_thread);
    
    while (true) {
        // Signal flags that are reported as event are automatically cleared.
        osSignalWait(0x1, osWaitForever);
        led = !led;
    }
}