#include "mbed.h"
#include "rtos.h"

DigitalOut led(LED1);

void led_thread(void const *argument) {
  while (true) {
    // Signal flags that are reported as event are automatically cleared.
    osEvent evt = Thread::signal_wait(0);            //Wait for any signal
    switch(evt.status) {
      case osOK:
        printf("osOK\n");                            //no error or event occurred
        break;
      case osEventSignal:
        printf("osEventSignal = %#05x\n",evt.value.signals); //signal event occurred
        break;              
      case osEventTimeout:
        printf("osEventTimeout\n");                 //timeout occurred
        break;               
      case osErrorValue:
        printf("osErrorValue\n");                   //value of a parameter is out of range
        break;               
      default:
        printf("Unknown error flag: %#08x\n",(uint32_t)evt.status);
        break;
    };
    led = !led;
  }
}

int main (void) {
  int32_t signal_mask = 0x1;
  Thread thread2(led_thread);
  while (true) {
    Thread::wait(1000);
    thread2.signal_set(signal_mask);
    signal_mask <<=1;
    if(signal_mask > 0x8000) signal_mask=0x1;
  }
}