#include "mbed.h"
#include "rtos.h"

Semaphore s(5);                        // a pool of 5 chopsticks
Timer mytime;

void notify(const char* name) {
    printf("%s acquired two chopsticks %8.1f\n\r", name,mytime.read());
}

void test_thread(void const* args) {
    while (true) {
        Thread::wait(1000+rand()%500); //Thinking   
        s.wait();
        s.wait();        
        notify((const char*)args);
        Thread::wait(500+rand()%500);  //Eating
        s.release();
        s.release();        
    }
}

int main (void) {
    mytime.start();
    Thread t2(test_thread, (void *)"Philosopher 2");
    Thread t3(test_thread, (void *)"Philosopher 3");
    Thread t4(test_thread, (void *)"Philosopher 4");
    Thread t5(test_thread, (void *)"Philosopher 5");    
    test_thread((void *)"Philosopher 1");
}